$(function(){
	var scripturl = location.href.split('?').shift(), mts, safe_mode;
	// !auth dialog
	var $ad = $("#authDialog").dialog({
		autoOpen: false,
		width: 500,
		modal: true,
		buttons: {
			'認証': function(){
				var data = $("input", $ad).serialize();
				$.post(scripturl, data, function(res){
					if (mts = res.match(/<result>(.*?)<\/result>/)) {
						res = mts[1];
						if (res.match(/^valid$/)) {
							$("#authStatus").html('<span style="color:lightgreen">認証に成功しました</span>');
							getDesigns();
						} else {
							$("#authStatus").html('<span style="color:red">'+res+'</span>');
						}
					} else {
						$("#authStatus").html('<span style="color:red">QHMからログアウトしています<br /><a href="'+scripturl+'?cmd=qhmauth">こちら</a>からログインしてください</span>');
					}
				});
			},
			'キャンセル': function(){
				$ad.dialog('close');
			}
		}
	});
	$("#qhmDesignGetter").click(function(){
		var data = {
			phase: 'club',
			mode: 'has_qhm',
			plugin: 'qhmsetting',
			pcmd: 'post',
			from: 'design_form'
		};
		$.get(scripturl, data, function(res){
			safe_mode = res.match(/<safe_mode>1<\/safe_mode>/)? true: false;//safe mode?
			if (mts = res.match(/<result>(.*?)<\/result>/)) {
				res = mts[1];
				if (res.match(/^valid$/)) {
					getDesigns();
				} else {
					$ad.dialog('open');
				}
			} else {
				//TODO: logout message
			}
		});
		return false;
	});
	
	// !FTP Dialog
	var $ftpd = $("#ftpDialog")
	.data("downloadDesign", false)
	.dialog({
		title: 'FTP 接続',
		autoOpen: false,
		width: 500,
		modal: true,
		buttons: {
			'接続': function(){
				var data = $("input", $ftpd).serialize();
				$.post(scripturl, data, function(res){
					if (mts = res.match(/<result>(.*?)<\/result>/)) {
						res = mts[1];
						if (res.match(/^OK$/)) {
							$("#ftpStatus").html('<span style="color:lightgreen">フォルダの作成に成功しました</span>');
							setTimeout(function(){
								$ftpd.dialog('close');
								$("#ftpStatus").empty();
							}, 500);
							downloadDesign($("input:hidden[name='design_name']", $ftpd).val());
						} else if (res.match(/^NG_Dir$/)) {
							$("#ftpusedir").val(1);
							$("#ftpStatus").html('<span style="color:red">設置先が特定できません。設置先ディレクトリを指定してください。</span>');
							$("#ftpDirRow").show().focus().select();
						} else {
							$("#ftpStatus").html('<span style="color:red">'+res+'</span>');
						}
					} else {
						$("#ftpStatus").html('<span style="color:red">QHMからログアウトしています<br /><a href="'+scripturl+'?cmd=qhmauth">こちら</a>からログインしてください</span>');
					}
				});
			},
			'キャンセル': function(){
				$ftpd.dialog('close');
				$("#ftpStatus").empty();
			}
		}
	});
	
	// !design dialog
	var $dd = $("#designDialog")
	.data("hasDesign", false)
	.data("isPrem", false)
	.dialog({
		title: '取得できるデザイン一覧',
		autoOpen: false,
		width: 800,
		height: 650,
		modal: true,
		position: [220, 10],
		buttons: {
			'取得': function(){
				var design = $("input:radio[checked]", $dd).val();
				if (safe_mode) {
					$("input:hidden[name=design_name]", $ftpd).val(design);
					$ftpd.dialog('open');
				} else {
					downloadDesign(design);
				}
			},
			'キャンセル': function(){
				$dd.dialog('close');
			}
		},
		close: function(){
			$fd.dialog('close');
		}
	});
	
	// !fragment dialog
	var $fd = $("#fragDialog")
	.dialog({
		autoOpen: false,
		width: 200,
		height: 650,
		position: [5, 10],
		buttons: {
			'閉じる': function(){
				$fd.dialog('close');
			}
		}
	});
	$("a", $fd).each(function(){
		var $$ = $(this);
		$$.css({
			color: "#00f"
		})
		.click(function(){
			var $td = $($$.attr("href")),
				$tr = $td.parent(),
				rowIndex = $tr.get(0).sectionRowIndex,
				trHeight = $tr.height();
//			console.log('offset top: ' + $to.position().top);
			$("#designDialog")
			.animate({scrollTop: rowIndex * trHeight}, 'fast');
			return false;
		});
	});

	function downloadDesign(design) {
		var data = {
			phase: 'club',
			mode: 'download_design',
			plugin: 'qhmsetting',
			pcmd: 'post',
			from: 'design_form',
			design: design
		};
		$.post(scripturl, data, function(res){
			if (mts = res.match(/<result>(.*?)<\/result>/)) {
				res = mts[1];
				if (res.match(/^OK$/)) {
					var msg = '';
					//持っているデザインをダウンロードした場合は増やさない
					if ($("#designList input:radio[value="+design+"]").length == 0) {
						//デザインを増やす
						var thumb = window.designData[design];
						var cell = '<td width="33%"><label><img src="'+thumb+'" width="180" height="200" alt="'+design+'" /><br /><input type="radio" name="qhmsetting[style_name]" value="'+design+'" />'+design+'</label></td>';
						var $tr = $("#designList tr:last");
						if ($("td", $tr).length == 3) {
							$("#designList").append('<tr></tr>');
							$tr = $("#designList tr:last");
						}
						$tr.append(cell);
						msg = 'デザイン【'+design+'】を取得完了しました';
						
						//delete|preview option を更新
						$("#removeSelector").empty();
						$("#previewSelector").empty();
						var html = '', prhtml = '';
						var $radios = $("#designList input:radio:not(.currentStyle)");
						var $prradios = $("#designList input:radio");
						if ($radios.length > 0) {
							$("#qhmdesignremove_holder").show();
						}
						$radios.each(function(){
							var d = $(this).val();
							html += '<option value="'+d+'">'+d+'</option>';
						});
						$prradios.each(function(){
							var d = $(this).val();
							prhtml += '<option value="'+d+'">'+d+'</option>';
						});
						$("#removeSelector").html(html);
						$("#previewSelector").html(prhtml);
						
						
					} else {
						msg = 'デザイン【'+design+'】のデータを更新しました';
					}
					$("#qhmdesignStatus").html('<span style="font-weight:bold">'+ msg +'</span>');
				} else {
					alert("デザインを取得できません");
				}
			} else {
				//TODO: logout message
			}
			$dd.dialog('close');
			$fd.dialog('close');
		});
	
	}	
	
	function getDesigns() {
		if ($dd.data("hasDesign")) {
			showDesigns();
			return;
		}
		var data = {
			phase: 'club',
			mode: 'get_designs',
			plugin: 'qhmsetting',
			pcmd: 'post',
			from: 'design_form'
		};
		$.ajax({
			url: scripturl,
			type: "POST",
			data: data,
			dataType: "text",
			success: function(res, result){
				if (mts = res.match(/<json>(.*?)<\/json>/)) {
					res = mts[1];
					if (typeof JSON != "undefined") {
						res = JSON.parse(res);
					} else {
						eval("res = " + res + ";");
					}

					//designDialog に入れ込む
					$dd.html('<table style="border:none;width:100%;background-color:#ddd"><tbody></tbody></table>');
					var $tbody = $("tbody", $dd);
					var cnt = 0, isPrem = null;
					for (var d in res) {
						if (isPrem == null) {
							if (d.match(/^i_/)) {
								isPrem = true;
							} else {
								isPrem = false;
							}
						}
						var frag = ' id="'+ d +'"';
						var thumb = res[d];
						if (cnt++ % 4 == 0) {
							$tbody.append("<tr></tr>");
						}
						$("tr:last", $dd).append('\
	<td style="width:25%;background-color:#fff;padding-bottom:10px;"'+frag+'>\
		<label><img src="'+ thumb +'" width="180" height="200" alt="'+d+'" /><br /><input type="radio" name="design" value="'+d+'" />'+d+'</label>\
	</td>');
						}
					$ad.dialog('close');
					if (cnt == 0) {
						alert("デザインを取得できません。");
					} else {
						//save design data
						window.designData = res;
						$dd.data("hasDesign", true);
						$dd.data("isPrem", isPrem);
						showDesigns();
					}
				} else {
					//TODO: logout message
				}
			},
			error: function(){},
			complete: function(){}
		});
	}
	
	function showDesigns() {
		$dd.dialog('open');
		if ($dd.data("isPrem")) {
			$fd.dialog('open');
		}
	}
	
	
	// !loading event
	$("body").append('<div id="loading"><img src="image/loadingAnimation.gif" width="208" height="13" alt="Now Loading..." /></div>');
	$("#loading")
	.css({
		zIndex: 99999999,
		width: 208,
		height: 13,
		display: "none",
		position: "fixed",
		left: "50%",
		top: "50%",
		marginLeft: -104,
		marginTop: -7
	})
	.bind('ajaxSend', function(){
		$(this).fadeIn(200);
	})
	.bind('ajaxComplete', function(){
		$(this).fadeOut(200);
	});

	
	// !logo radio button
	$("#logoImageButton").click(function(){$("#logoImageRadio").click()});
	$("#logoTextInput").focus(function(){$("#logoTextRadio").click()});
	
});