<?php
// PukiWiki - Yet another WikiWikiWeb clone.
// $Id: pukiwiki.php,v 1.11 2005/09/11 05:58:33 henoheno Exp $
//
// PukiWiki 1.4.*
//  Copyright (C) 2002-2005 by PukiWiki Developers Team
//  http://pukiwiki.sourceforge.jp/
//
// PukiWiki 1.3.*
//  Copyright (C) 2002-2004 by PukiWiki Developers Team
//  http://pukiwiki.sourceforge.jp/
//
// PukiWiki 1.3 (Base)
//  Copyright (C) 2001-2002 by yu-ji <sng@factage.com>
//  http://factage.com/sng/pukiwiki/
//
// Special thanks
//  YukiWiki by Hiroshi Yuki <hyuki@hyuki.com>
//  http://www.hyuki.com/yukiwiki/
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

if (! defined('DATA_HOME')) define('DATA_HOME', '');

/////////////////////////////////////////////////
// Include subroutines

if (! defined('LIB_DIR')) define('LIB_DIR', '');



require(LIB_DIR . 'func.php');
require(LIB_DIR . 'file.php');
require(LIB_DIR . 'plugin.php');
require(LIB_DIR . 'html.php');
require(LIB_DIR . 'backup.php');

require(LIB_DIR . 'convert_html.php');
require(LIB_DIR . 'make_link.php');
require(LIB_DIR . 'diff.php');
require(LIB_DIR . 'config.php');
require(LIB_DIR . 'link.php');
require(LIB_DIR . 'auth.php');
require(LIB_DIR . 'proxy.php');
if (! extension_loaded('mbstring')) {
	require(LIB_DIR . 'mbstring.php');
}

// Defaults
$notify = $trackback = $referer = 0;

// Load *.ini.php files and init PukiWiki
require(LIB_DIR . 'init.php');

// Load authorization library  QQQ
require(LIB_DIR .'ss_authform.php');
ss_auth_start();

//strip session_name from $vars['page']
if($vars['page'] === session_name().'='.session_id())
	$vars['page'] = $defaultpage;

// Load optional libraries
if ($notify) {
	require(LIB_DIR . 'mail.php'); // Mail notification
}
if ($trackback || $referer) {
	// Referer functionality uses trackback functions
	// without functional reason now
	require(LIB_DIR . 'trackback.php'); // TrackBack
}

require(PLUGIN_DIR . 'secedit.inc.php');

//load very light template engine
require_once(LIB_DIR.'qhm_template.php');


/////////////////////////////////////////////////
// Main

$retvars = array();
$is_cmd = FALSE;
if (isset($vars['cmd'])) {
	$is_cmd  = TRUE;
	$plugin = & $vars['cmd'];
} else if (isset($vars['plugin'])) {
	$plugin = & $vars['plugin'];
} else {
	$plugin = '';
}
if ($plugin != '') {
	if (exist_plugin_action($plugin)) {
		// Found and exec
		$retvars = do_plugin_action($plugin);
		if ($retvars === FALSE) exit; // Done

		if ($is_cmd) {
			$base = isset($vars['page'])  ? $vars['page']  : '';
		} else {
			$base = isset($vars['refer']) ? $vars['refer'] : '';
		}
	} else {
		// Not found
		$msg = 'plugin=' . htmlspecialchars($plugin) .
			' is not implemented.';
		$retvars = array('msg'=>$msg,'body'=>$msg);
		$base    = & $defaultpage;
	}
}

$title = htmlspecialchars(strip_bracket($base));
$page  = make_search($base);
if (isset($retvars['msg']) && $retvars['msg'] != '') {
	$title = str_replace('$1', $title, $retvars['msg']);
	$page  = str_replace('$1', $page,  $retvars['msg']);
}


//------------------------------------------------------
// * サイト全体を閉鎖するオプションがOnの場合、
//　　qhmloginへのアクセス以外、全部、「閉鎖中」を出す
// 2009 6/18 (by hokuken.com)
//------------------------------------------------------
if( $site_close_all &&  !ss_admin_check() ){
	$_SESSION['usr'] = null;
	output_site_close_message($page_title, $script.'?cmd=qhmauth');
	exit;
}
//--

if (isset($retvars['body']) && $retvars['body'] != '') {
	$body = & $retvars['body'];
} else {
	if ($base == '' || ! is_page($base)) {
		$base  = & $defaultpage;
		$title = htmlspecialchars(strip_bracket($base));
		$page  = make_search($base);
	}

	$vars['cmd']  = 'read';
	$vars['page'] = & $base;

	//--------------------------------------------------------------------------
	//
	// * キャッシュを有効にするカスタマイズ by hokuken.com
	//
	// ・編集モードの場合、キャッシュは強制的に無効
	//
	// ・キャッシュは、有効だが、キャッシュファイル無効の場合は、$create_cache_mode = true;
	// 　として、動的にロードされるべきプラグインの制御を有効にする(ex: popularプラグインなど)
	//
	// ・キャッシュが有効で、キャッシュファイルがあるなら、キャッシュを出力
	//
	//--------------------------------------------------------------------------

	//編集状態の場合、強制的にキャッシュを無効
	$enable_cache = edit_auth($base, FALSE, FALSE)===TRUE ? false : $enable_cache;
	
	//携帯の場合、強制的にキャッシュ機能をオフ。もし、転送設定があれば、転送する
	if( preg_match('/keitai.skin.php$/', SKIN_FILE) ){
		$enable_cache = false;
		
		if( is_url( $mobile_redirect ) ){
			header('Location: '. $mobile_redirect);
			exit;
		}
	}
	
	//$scriptが変化している場合、キャッシュの有効期限をリフレッシュ
	chk_script($script);

	if( $enable_cache ){ //キャッシュ有効
		if( need_update_cache($base) ){
			$create_cache_mode = true;
			$body  = convert_html(get_source($base));
			
			if($enable_cache == false){ //プラグインによってキャッシュを無効にされている場合
				//動的プラグインを実行しておく
				$create_cache_mode = false;
				$body = replace_dynamic_plugin('', $body, true);
			}
		}
		else{
			//output & exit
			output_wiki_cache($base);
			exit;
		}
	}
	else{
		$body  = convert_html(get_source($base));
	}
	
	if ($trackback) $body .= tb_get_rdf($base); // Add TrackBack-Ping URI
	if ($referer) ref_save($base);
}

// Output
catbody($title, $page, $body);
exit;
?>
