<?php
//-------------------------------------------------
// QHM Initialization program for skin (output)
// This file is required lib/html.php
//
// QHMの編集モードで使う変数などを初期化、設定
// 最後に、ヘッダーの出力までを担当する
//


//qhmpro check
$is_qhmpro = (isset($other_plugins) && count($other_plugins) > 0);
$qhmpro_site = 'http://www.1st-easy-hp.com/p/qhmpro/';
$openqhm_help = 'http://www.open-qhm.net/?QHMHelp';
$is_setting = ( ($vars['cmd']=='qhmsetting') || ($vars['plugin'] =='qhmsetting') );

//---- set ini values for template engine
$_qhm_values['keywords'] = $keywords;
$_qhm_values['description'] = $description;
$_qhm_values['custom_meta'] = $custom_meta;
$_qhm_values['head_tag'] = $head_tag; //使ってる？
$_qhm_values['beforescript'] = $beforescript;
$_qhm_values['modifierlink'] = $modifierlink;
$_qhm_values['modifier'] = $modifier;
$_qhm_values['owneraddr'] = $owneraddr;
$_qhm_values['ownertel'] = $ownertel;
$_qhm_values['lastscript'] = $lastscript;
$_qhm_values['_page'] = $_page;
$_qhm_values['_script'] = $script;

$_go_url = $script.'?go='.get_tiny_code($_page);
$_qhm_values['go_url'] = $_go_url;
$_qhm_rawurl = $script.'?'.rawurlencode($_page);

//---- Prohibit direct access
if (! defined('UI_LANG')) die('UI_LANG is not set');
if (! isset($_LANG)) die('$_LANG is not set');
if (! defined('PKWK_READONLY')) die('PKWK_READONLY is not set');

$link  = & $_LINK;
$image = & $_IMAGE['skin'];
$rw    = ! PKWK_READONLY;

$_qhm_values['rss_link'] = $link['rss'];

//---- define global values for some plugin.
global $accesstag_moved ; //ganatracker.inc.php setting (GoogleAnalytics)
global $shiftjis; //Shift-JIS converter
global $eucjp; //EUC-JP converter

if ($shiftjis)   { define('TEMPLATE_ENCODE','Shift_JIS'); }
else if ($eucjp) { define('TEMPLATE_ENCODE','EUC-JP'); }
else             { define('TEMPLATE_ENCODE','UTF-8'); }

$qhm_dir = (preg_match('/.*\.php/',$script)) ? dirname($script) : dirname($script.'index.php');
$_qhm_values['qhm_dir'] = $qhm_dir;

$_qhm_values['clickpad_js'] = "";

// Set toolbar-specific images
$_IMAGE['skin']['edit']     = 'edit.png';
$_IMAGE['skin']['diff']     = 'diff.png';
$_IMAGE['skin']['upload']   = 'file.png';
$_IMAGE['skin']['list']     = 'list.png';
$_IMAGE['skin']['search']   = 'search.png';
$_IMAGE['skin']['recent']   = 'recentchanges.png';
$_IMAGE['skin']['backup']   = 'backup.png';
$_IMAGE['skin']['help']     = 'help.png';
$_IMAGE['skin']['rss']      = 'rss.png';
$_IMAGE['skin']['rss10']    = & $_IMAGE['skin']['rss'];
$_IMAGE['skin']['rss20']    = 'rss20.png';
$_IMAGE['skin']['rdf']      = 'rdf.png';
$_IMAGE['skin']['rename']   = 'rename.png';
$_IMAGE['skin']['menuadmin']   = 'menuadmin.png';


// Editable mode preparation
$_qhm_values['editable'] = check_editable($_page, FALSE, FALSE);

$has_swfu = file_exists('swfu/config.php')? 'window.qhm_has_swfu = 1;'. "\n": '';
$has_fwd3 = file_exists('fwd3/sys/config.php')? 'window.qhm_has_fwd3 = 1;'. "\n": '';

// other_plugin button
if ($is_qhmpro) {
	$op_func = <<<EOD
	var op = $("div.other_plugin");
	var optitle = $("div.other_plugin_box_title");
	if (!op.is(':visible')) {
		op.fadeIn("fast");
		if (!optitle.is(".expand")) {
			optitle.click();
		}
		document.cookie = "otherplugin=show";
	}
	else {
		op.fadeOut("fast");
		if (optitle.is(".expand")) {
			optitle.click();
		}
		document.cookie = "otherplugin=hide";
	}
EOD;
}
else {
	$op_func = <<<EOD
	window.open('{$openqhm_help}', 'help', 'dependent=no, location=yes, menubar=yes, resizable=yes, scrollbars=yes, status=yes, titlebar=yes, toolbar=yes');
EOD;
}

// $_qhm_values['toolkit_upper'] = '';  //ga_linkプラグインによって追加されるので初期化しない
$_qhm_values['toolkit_bottom'] = '';

if(($_qhm_values['editable'] || ss_admin_check()) && !$is_setting){
	$jquery_include = true;
    $_qhm_values['clickpad_js'] = <<<EOD
<!--[if IE 6]><script type="text/javascript" src="js/fixed.js"></script><![endif]-->
<script type="text/javascript" src="js/thickbox.js"></script>
<script type="text/javascript" src="js/jquery.clickpad.js"></script>
<script type="text/javascript" src="js/jquery.shortkeys.js"></script>
<script type="text/javascript" src="js/jquery.edit.js"></script>
<script type="text/javascript">
{$has_swfu}{$has_fwd3}
$(document).ready(function(){
	// clickpad
	if($("#msg").length) {
		$("#msg").clickpad({buttons:"qhm",autoGrow:false});
		otherplugin = function(){
{$op_func}
		};
		var ck = document.cookie.split(";");
		for (var i = 0; i < ck.length; i++) {
			if (ck[i].split("=")[0].replace(/^\s|\s$/, '').match(/otherplugin/)
				&& ck[i].split("=")[1].replace(/^\s|\s$/, '').match(/show/)) {
				otherplugin();
			}
		}
	}
});
</script>
<link rel="stylesheet" media="screen" href="{$qhm_dir}/skin/hokukenstyle/qhm.css" type="text/css" charset="Shift_JIS" />
<link rel="stylesheet" media="screen" href="js/thickbox.css" type="text/css" charset="Shift_JIS" />

EOD;

	$link_help = ($is_qhmpro) ? $qhmpro_site : $openqhm_help;
	$link_map = $script.'?cmd=map&amp;refer='.rawurlencode($_page);
	$link_password = $script.'?plugin=qhmsetting&phase=user2&mode=form';

	$tools = array(
	'toplink'     => array('name'=>'トップへ', 'link'=>$script, 'style'=>'', 'class'=>'', 'visible'=>true, 'sub'=>array()),
	'editboxlink' => array('name'=>'編集ボックスへ', 'link'=>'#msg', 'style'=>'', 'class'=>'go_editbox', 'visible'=>true, 'sub'=>array()),
	'editlink'    => array('name'=>'編集', 'link'=>$link_edit, 'style'=>'margin-top:1.1em;', 'class'=>'', 'visible'=>true, 'sub'=>array()),
	'reflink'     => array('name'=>'添付', 'link'=>$link_upload, 'style'=>'', 'class'=>'swfu', 'visible'=>true, 'sub'=>array()),
	'pagelink'    => array('name'=>'このページの', 'link'=>'', 'style'=>'margin-top:1.1em;', 'class'=>'', 'visible'=>true, 'sub'=>array(
			'difflink' => array('name'=>'差分', 'link'=>$link_diff, 'style'=>'','class'=>'', 'visible'=>true, ),
			'backuplink' => array('name'=>'バックアップ', 'link'=>$link_backup, 'style'=>'','class'=>'', 'visible'=>true, ),
			'renamelink' => array('name'=>'名前変更', 'link'=>$link_rename, 'style'=>'','class'=>'', 'visible'=>true, ),
			'maplink' => array('name'=>'マップ', 'link'=>$link_map, 'style'=>'','class'=>'', 'visible'=>true, ),
			'copylink' => array('name'=>'複製', 'link'=>$link_copy, 'style'=>'','class'=>'', 'visible'=>true, ),
			'tinyurllink' => array('name'=>'URL', 'link'=>'#', 'style'=>'','class'=>'', 'visible'=>true, ),
		)),
	'sitelink'   => array('name'=>'サイトの', 'link'=>'', 'style'=>'', 'class'=>'', 'visible'=>true, 'sub'=>array(
			'navilink' => array('name'=>'ナビ編集', 'link'=>$link_edit_navi, 'style'=>'','class'=>'', 'visible'=>true, ),
			'menulink' => array('name'=>'メニュー編集', 'link'=>$link_edit_menu, 'style'=>'','class'=>'', 'visible'=>true, ),
			'navi2link' => array('name'=>'ナビ2編集', 'link'=>$link_edit_navi2, 'style'=>'','class'=>'', 'visible'=>true, ),
			'newlink' => array('name'=>'新規ページ作成', 'link'=>$link_new, 'style'=>'margin-top:1em;','class'=>'', 'visible'=>true, ),
			'whatnewlink' => array('name'=>'更新履歴', 'link'=>$link_whatsnew, 'style'=>'','class'=>'', 'visible'=>true, ),
			'pagelistlink' => array('name'=>'ページ一覧', 'link'=>$link_filelist, 'style'=>'','class'=>'', 'visible'=>true, ),
			'yetlistlink' => array('name'=>'リンク切れ', 'link'=>$link_yetlist, 'style'=>'','class'=>'', 'visible'=>true, ),
		)),
	'toollink'   => array('name'=>'ツール', 'link'=>'', 'accesskey'=>'', 'style'=>'', 'class'=>'', 'visible'=>true, 'sub'=>array(
			'swfulink' => array('name'=>'SWFU', 'link'=>'swfu/index.php', 'style'=>'','class'=>'swfu', 'visible'=>true, ),
			'fwd3link' => array('name'=>'FWD3', 'link'=>'fwd3/sys/', 'style'=>'','class'=>'', 'visible'=>true, ),
			'qdsgnlink' => array('name'=>'QDesigner', 'link'=>'qdsgn/index.php', 'style'=>'','class'=>'', 'visible'=>true, ),
			'searchlink' => array('name'=>'単語検索', 'link'=>$link_search, 'style'=>'','class'=>'', 'visible'=>true, ),
		)),
	'configlink' => array('name'=>'設定', 'link'=>$link_qhm_setting, 'style'=>'margin-top:1.1em;', 'visible'=>true, 'sub'=>array()),
	'helplink'   => array('name'=>'ヘルプ', 'link'=>$link_help, 'style'=>'', 'visible'=>true, 'sub'=>array()),
	'passwordlink'   => array('name'=>'パスワード変更', 'link'=>$link_password, 'style'=>'', 'visible'=>true, 'sub'=>array()),
	'logoutlink' => array('name'=>'[×]ログアウト', 'link'=>$link_qhm_logout, 'style'=>'margin-top:1.1em;', 'visible'=>true, 'sub'=>array()),
	);

	if (!$is_page) {
		if (isset($tools['editboxlink'])) unset($tools['editboxlink']);
		$tools['editlink']['visible'] = false;
		$tools['reflink']['visible'] = false;
		$tools['pagelink']['visible'] = false;
	}
	if (!$rw) {
		$tools['editlink']['visible'] = false;
		$tools['reflink']['visible'] = false;
	}
	if (!(bool)ini_get('file_uploads')) { 
		$tools['reflink']['visible'] = false;
	}
	if(!file_exists('swfu/index.php')) {
		$tools['toollink']['sub']['swfulink']['visible'] = false;
		$tools['reflink']['class'] = '';
	}
	else {
		$tools['reflink']['link'] = 'swfu/index_child.php?page='.rawurlencode($vars['page']).'&amp;KeepThis=true&amp;TB_iframe=true';
	}
	if(!file_exists('fwd3/sys/fwd3.txt')) {
		$tools['toollink']['sub']['fwd3link']['visible'] = false;
	}
	if(!file_exists('qdsgn/index.php')) {
		if (isset($tools['toollink']['sub']['qdsgnlink'])) unset($tools['toollink']['sub']['qdsgnlink']);
	}
	if( !ss_admin_check()){
		if (isset($tools['reflink'])) unset($tools['reflink']);
		if (isset($tools['pagelink'])) unset($tools['pagelink']);
		if (isset($tools['sitelink'])) unset($tools['sitelink']);
		if (isset($tools['configlink'])) unset($tools['toollink']);
		if (isset($tools['configlink'])) unset($tools['configlink']);
		if (isset($tools['helplink'])) unset($tools['helplink']);
	}
	else {
		if (isset($tools['passwordlink'])) unset($tools['passwordlink']);
	}
	
	$tools_str = '<ul class="toolbar_menu">';
	foreach ($tools as $lv1key => $lv1) {
		// main menu
		$style = ($lv1['style'] != '') ? $lv1['style'] : '';
		// visible
		if ($lv1['visible']) {
			// link
			if ($lv1['link'] != '') {
				$class= ($lv1['class'] != '') ? ' class="'.$lv1['class'].'"' : '';
				$target = ($lv1key == 'helplink') ? ' target="help"' : '';
				$tools_str .= '<li style="background-image:none;'.$style.'"'.$class.'><a href="'.$lv1['link'].'"'.$target.' id="'.$lv1key.'">'.$lv1['name'].'</a>';
			}
			else {
				$class= ($lv1['class'] != '') ? ' class="'.$lv1['class'].'"' : '';
				$style = ($style != '') ? ' style="position:relative;'.$class.$style.'"' : ' style="position:relative;"';
				$tools_str .= '<li'.$style.'>'.$lv1['name'];
			}
		}
		// invisible
		else {
			$tools_str .= '<li style="background-image:none;" class="nouse">'.$lv1['name'];
		}

		// sub menu
		if (count($lv1['sub']) > 0) {
			$tools_str .= '<ul class="toolbar_submenu">';
			foreach ($lv1['sub'] as $lv2key => $lv2) {
				$class= ($lv2['class'] != '') ? ' class="'.$lv2['class'].'"' : '';
				$style = ($lv2['style'] != '') ? ' style="'.$lv2['style'].'"' : '';
				$tools_str .= '<li'.$class.$style.'>';
				// visible
				if ($lv2['visible']) {
					// link
					if ($lv2['link'] != '') {
						$target = '';
						$tools_str .= '<a href="'.$lv2['link'].'"'.$target.' id="'.$lv2key.'">'.$lv2['name'].'</a>';
					}
					else {
						$tools_str .= $lv2['name'];
					}
				}
				// invisible
				else {
					$tools_str .= '<li style="background-image:none;" class="nouse">'.$lv2['name'];
				}
				$tools_str .= '</li>';
			}
			$tools_str .= '</ul>'; // sub menu end
		}
		$tools_str .= '</li>';
	}
	$tools_str .= '</ul>'; // main manu end

	//クッキーで大きさを調節
	if(isset($_COOKIE['toolbar_size']) && $_COOKIE['toolbar_size'] == 'min'){
		$tb_max_disp = 'display:none';
		$tb_min_disp = '';	
	}
	else{
		$tb_max_disp = '';
		$tb_min_disp = 'display:none';
	}
	
	//toolbar_bottom
	$_qhm_values['toolkit_bottom']  = '';
	
	
	//最大化型のtoolbar_upper
	$_qhm_values['toolkit_upper'] .= '<!-- Toolbar upper --><div id="toolbar_upper_max" class="toolbar_upper" style="'.$tb_max_disp.'"><div class="toolkit_switch expand toolline">[ー]</div>';
	$_qhm_values['toolkit_upper'] .= '<div>'.$tools_str.'</div>';
	$_qhm_values['toolkit_upper'] .= '</div>';

//最小化型のtoolbar upper
	$tools_str = preg_replace('/\sid="([a-z_]+?)"/', ' id="$1_min"', $tools_str);
	$tools_str = str_replace('toolbar_menu', 'toolbar_menu_min', $tools_str);
	$tools_str = str_replace('margin-top:1.1em;', '', $tools_str);

	$_qhm_values['toolkit_upper'] .= '<!-- Toolbar upper --><div id="toolbar_upper_min" class="toolbar_upper" style="border-bottom:1px dashed #999;position:fixed;top:0px;left:0px;line-height:0.8em;'.$tb_min_disp.'"><div class="toolkit_switch toolleft">[＋]</div>';
	$_qhm_values['toolkit_upper'] .= '<div style="float:left;">'.$tools_str.'</div>';
	$_qhm_values['toolkit_upper'] .= '</div>';

	//php setting check warning
	if( defined('WARNING_OF_ENCODING') ){
		$_qhm_values['toolkit_upper'] = '<p style="font-size:16px;color:white;width:600px;margin:5px auto;background-color:#e00">このサーバーは、設定を変更しないと、文字化けして編集ができません<br />お手数ですが、<a href="http://www.open-qhm.net/index.php?ServerSettingError">ここをクリック</a>して、サーバー設定、もしくは、レンタルサーバー業者にお問い合わせ下さい。</p>'.$_qhm_values['toolkit_upper'];
	}

	//shortcut 一覧
	$_qhm_values['toolkit_upper'] .= '
<div id="shortcut_list">
<p style="text-align:right;padding-right:20px;margin:0;"><a href="#" style="color:#ddd;font-size:13px">[x]閉じる</a></p>
<table style="border:none;background-color:transparent;">
	<thead>
		<tr>
			<th width="80">&nbsp;</th>
			<th width="320">編集</th>
			<th width="80">&nbsp;</th>
			<th width="320">ジャンプ</th>
		</tr>
	</thead>
	<tbody>
		<tr>
			<th style="color:yellow;text-align:right;">esc</th>
			<td>テキストエリアのフォーカスを外す</td>
			<th style="color:yellow;text-align:right;">g -> t</th>
			<td>トップへスクロール</td>
		</tr>
		<tr>
			<th style="color:yellow;text-align:right;">g -> e</th>
			<td>編集画面へ移動</td>
			<th style="color:yellow;text-align:right;">g -> h</th>
			<td>ホームへ移動</td>
		</tr>
		<tr>
			<th style="color:yellow;text-align:right;">g -> p</th>
			<td>ページのプレビュー</td>
			<th style="color:yellow;text-align:right;">g -> q</th>
			<td>単語検索</td>
		</tr>
		<tr>
			<th style="color:yellow;text-align:right;">g -> s</th>
			<td>ページの更新</td>
			<th style="color:yellow;text-align:right;">g -> n</th>
			<td>新規ページ作成</td>
		</tr>
		<tr>
			<th style="color:yellow;text-align:right;">g -> a</th>
			<td>添付（SWFU）</td>
			<th style="color:yellow;text-align:right;">g -> m</th>
			<td>マップ</td>
		</tr>
		<tr>
			<th style="color:yellow;text-align:right;">g -> i</th>
			<td>イメージ（SWFU）</td>
			<th style="color:yellow;text-align:right;">g -> l</th>
			<td>ファイル一覧</td>
		</tr>
		<tr>
			<th style="color:yellow;text-align:right;">g -> o</th>
			<td>その他のツールを開く</td>
			<th style="color:yellow;text-align:right;">g -> c</th>
			<td>システム設定</td>
		</tr>
		<tr>
			<th style="color:yellow;text-align:right;">/</th>
			<td>テキストエリアにフォーカスする</td>
			<th style="color:yellow;text-align:right;">g -> f</th>
			<td>FWD3</td>
		</tr>
		<tr>
			<th style="color:yellow;text-align:right;">g -> u</th>
			<td>URL</td>
			<th style="color:yellow;text-align:right;">g -> ?</th>
			<td>会員サイトを開く</td>
		</tr>
		<tr>
			<th style="color:yellow;text-align:right;">&nbsp;</th>
			<td>&nbsp;</td>
			<th style="color:yellow;text-align:right;">g -> g</th>
			<td>Google を開く</td>
		</tr>
	</tbody>
</table>
</div>
';

	//短縮URL
	$_qhm_values['toolkit_upper'] .= '
<div id="tinyUrl">
	<p style="text-align:right;margin:0;font-size:14px;"><a href="#">[x]閉じる</a></p>
	<table style="margin:0 auto;width:100%">
		<tr>
			<th>短縮URL</th>
			<td><input type="text" value="'.$_go_url.'" readonly="readonly"  onclick="this.select();" size="36" /></td>
		</tr>
		<tr>
			<th>URL</th>
			<td><input type="text" value="'.$_qhm_rawurl.'" readonly="readonly" onclick="this.select();"  size="36" /></td>
		</tr>
	</table>
</div>

';

	// other plugin
	$op_html = '';
	if ($is_qhmpro) {
		$op_cat = array();
		$op_html  = '<div class="other_plugin">';
		$op_html .= '<div class="other_plugin_box_title expand"><span>その他のツール</span>&nbsp;&nbsp;<span class="mark">ー</span></div>';
		$op_html .= '<div class="other_plugin_box">';
		$op_html_box = "";
		foreach ($other_plugins as $opkey => $op) {
			$insert_cmd = $op['insert'];
			$insert_cmd = str_replace("\n", "##LF##", $insert_cmd);
			$op_html_box = '<li class="'.$op['help'].'"><span class="opname">'.$op['name'].'</span><span class="insert_cmd">'.$insert_cmd.'</span></li>';
			$op_cat[$op['category']][] = $op_html_box;
		}
		$op_html .= '<ul class="other_plugin_menu">';
		foreach ($other_plugin_categories as $catkey => $catname) {
			$op_html_menu  = '<li>'.$catname;
			$op_html_menu .= '<ul class="other_plugin_sub">';
			$op_html_menu .= implode('', $op_cat[$catkey]);
			$op_html_menu .= '</ul></li>';
			$op_html .= $op_html_menu;
		}
		$op_html .= '</ul>';
	
		$op_html .= "</div>";
		$op_html .= "</div>\n";
	}
	$_qhm_values['toolkit_upper'] .= $op_html;

}

else if ($qhm_adminmenu == 0){
	$_qhm_values['toolkit_bottom'] = $is_page ? '<div id="toolbar"><a href="'.$link_edit.'" '.$accesskey["e"].'>Edit this page</a></div>': '<div id="toolbar">このページは編集できません</div>';
}

//Quick PayPal用の変数設定
global $qp_here;
if($qp_here){
	$_qhm_values['qp_here_start'] = '';
	$_qhm_values['qp_here_end'] = '';	
}
else{
	$_qhm_values['qp_here_start'] = '<!-- BODYCONTENTS START -->';
	$_qhm_values['qp_here_end'] = '<!-- BODYCONTENTS END -->';
}


//set page title (title tag of HTML)
global $newtitle, $newbase, $freetitle;
$_qhm_values['this_page_title'] = '';
$_qhm_values['this_right_title'] = '';

if ($newtitle != '' && $is_read){
	$_qhm_values['this_page_title'] = $newtitle. " - " . $page_title;
	$_qhm_values['this_right_title'] = $newtitle;
}
else if ($freetitle != '' && $is_read){
	$_qhm_values['this_page_title'] = $freetitle;
	$_qhm_values['this_right_title'] = $freetitle;
}
else {
	$_qhm_values['this_page_title'] = $title. " - " .$page_title;
	$_qhm_values['this_right_title'] = $title;
}

if ($title == $defaultpage){
	$_qhm_values['this_page_title'] = $page_title;
}

//seach engine spider control
$_qhm_values['noindex'] = '';
if ($noindex || $nofollow || ! $is_read)  { 
 $_qhm_values['noindex'] = <<<EOD
 <meta name="robots" content="NOINDEX,NOFOLLOW" />
 <meta name="googlebot" content="noindex,nofollow" />
EOD;
}

//license
$qhm_admin_tag = ($qhm_adminmenu < 2) ? ' <a href="'. $link_qhm_adminmenu.'">QHM</a> ' : '';
$_qhm_values['licence_tag'] = "<p>".S_COPYRIGHT. $qhm_admin_tag."</p>";
if($no_qhm_licence){
	$_qhm_values['licence_tag'] = '';
}
$_qhm_values['qhm_login_link'] = $link_qhm_adminmenu;

//rss
$_qhm_values['rss_tag'] = '<a href="'.$script.'?cmd=rss&amp;ver=1.0"><img src="'.$qhm_dir.'/image/rss.png" width="36" height="14" alt="最新の更新 RSS" title="最新の更新 RSS" /></a>';

//access tag 
$_qhm_values['accesstag_tag'] = '';
if ($_qhm_values['editable'] === FALSE) { 
    if ($is_read && !$accesstag_moved)  { 
        $_qhm_values['accesstag_tag'] = $accesstag;
    }
}

$tmp_date = getdate();
$_qhm_values['today_year'] = $tmp_date['year'];


//misc info setting
$summaryflag_start = '';
$summaryflag_end = '';
if( ($notes != '') || ($trackback !='') || ($referer !='') || ($related != '') || ($attaches != '')  ){ 
 $summaryflag_start = '<div id="summary"><!-- ■BEGIN id:summary -->';
 $summaryflag_end = '</div><!-- □ END id:summary -->';
}

$attach_tag = '';
if ($attaches != '') {
 $attach_tag = <<<EOD
 <!-- ■ BEGIN id:attach -->
 <div id="attach">
 $hr
 $attaches
 </div><!-- □ END id:attach -->
EOD;
}

$notes_tag = '';
if ($notes != '') {
 $notes_tag = <<<EOD
 <!-- ■BEGIN id:note -->
 <div id="note">
   $notes
 </div>
 <!-- □END id:note -->
EOD;
}

$trackback_tag = '';
if ($trackback) {
   $tb_id = tb_get_id($_page);
   $tb_cnt = tb_count($_page);
  $trackback_tag = <<<EOD
<div id="trackback"><!-- ■BEGIN id:trackback -->
<a href="{$script}?plugin=tb&amp;__mode=view&amp;tb_id={$tb_id}" onClick="OpenTrackback(this.href); return false">TrackBack($tb_cnt)</a> | 
EOD;
}

$referer_tag = '';
if($referer){
  $referer_tag = <<<EOD
<a href="{$script}?plugin=referer&amp;page=$r_page">外部リンク元</a>
</div><!-- □ END id:trackback -->
EOD;
}

$related_tag = '';
if ($related != '') {
  $related_tag = <<<EOD
<!-- ■ BEGIN id:related -->
<div id="related">
Link: {$related}
</div>
<!-- □ END id:related -->
EOD;
}

$_qhm_values['summary'] = <<<EOD
<!-- summary start -->
{$summaryflag_start}
$notes_tag
$trackback_tag
$referer_tag
$related_tag
$attach_tag
$summaryflag_end
<!-- summary end -->
EOD;

//head
if($headcopy != ''){
	$_qhm_values['head_copy_tag'] = '<div id="headcopy">
<h1>'.$headcopy.'</h1>
</div><!-- END: id:headcopy -->
';
}

//JQuery Include
$_qhm_values['jquery_script'] = $jquery_include ? '<script type="text/javascript" src="js/jquery.js"></script>' : '';
$_qhm_values['jquery_cookie_script'] = $jquery_cookie_include ? '<script type="text/javascript" src="js/jquery.cookie.js"></script>' : '';
?>
