<?php
/*
 *  SixtyLinesTemplate.php - 60行しかないけどSmartyより速いテンプレートエンジン
 *  ref) http://anond.hatelabo.jp/20071030034313
 */

/*
 *  run template engine
 *  $_context は変数名をキー、値を要素とする連想配列。
 *  $encode 漢字コード変換をする場合は、trueを指定
 */

/* 
 * テンプレートがなければ、テンプレートキャッシュを作って読み込む。
 * もし、キャッシュが有効なら、ページのキャッシュを生成。
 * キャッシュが存在している場合は、lib/pukiwiki.php で出力され、ここにはこない
 */
function include_template(
	$_filename, 
	$_context, 
	$encode=false,
	$page=false
)
{
	global $create_cache_mode, $enable_cache;
	
    $_cachename = convert_template($_filename, $encode);
    $_context = $encode ?  encode_filter($_context) : $_context;

	extract($_context);
	mb_internal_encoding(TEMPLATE_ENCODE);

	if($create_cache_mode && $enable_cache && $page) //特定のプラグインで、無効にできる
	{
		//仮出力
		ob_start();
		include($_cachename);
		$body_str = ob_get_contents();
		ob_end_clean();
		
		//キャッシュ生成と、取り出し
		$body_str = create_wiki_cache($page, $body_str);
		echo $body_str;
		
	}
	else
	{
		include($_cachename); //output & exit here.
	}
}

/*
 *  filename を読み込み、convert_string() で置換してから
 *  filename.cache に書き込む。読み書きのロックは省略。
 *  (file_{get,put}_contents() はファイルロックできるようにすべきだ。)
 */
function convert_template($filename, $encode=false) {
    $sep = $encode ? '_'.TEMPLATE_ENCODE : ''; 
    $cachename = CACHE_DIR.str_replace('/','_',$filename).$sep.'.qtc';
		
    if (! file_exists($cachename) || filemtime($cachename) < filemtime($filename)) {
        $s = file_get_contents($filename);
        $s = convert_string($s);
		if ($encode) $s = mb_convert_encoding($s,TEMPLATE_ENCODE);
        file_put_contents($cachename, $s);
    }
    return $cachename;
}

/*
 *  テンプレートの中身を置換する。
 *  - '#{...}' を 'echo ...;' に置換
 *  - '%{...}' を 'echo htmlspecialchars(...);' に置換
 *  - ついでにXML宣言も置換
 */
function convert_string($s) {
/*    $s = preg_replace('/^<\?xml/', '<<?php ?>?xml', $s);*/
    $s = preg_replace('/#\{(.*?)\}/', '<?php echo $1; ?>', $s);
    $s = preg_replace('/%\{(.*?)\}/', '<?php echo htmlspecialchars($1); ?>', $s);
    return $s;
}

function encode_filter($param)
{
	if (is_array($param)) {
		return array_map('encode_filter', $param);
	} else {
		$result = mb_convert_encoding($param, TEMPLATE_ENCODE, CONTENT_CHARSET);
		return $result;
	}
}

/*
* キャッシュファイルの有効性をチェック
* 
* 説明 : 全ファイルの最終更新日であるqhm_lastmod.dat、仕様変更のためにqhm_template.php、
*　　　　　デザイン変更に対応するために、pukiwiki.ini.php より新しいことを条件とする
*　　　　　もちろん、キャッシュファイルがなければ、false
*/
function need_update_cache($page)
{
	$cache_name = CACHE_DIR.encode($page).'.tmp';
	$cache_name_r = CACHE_DIR.encode($page).'.tmpr';

	//添付ファイルチェック
	if(! file_exists($cache_name))
		return true;
	if(! file_exists($cache_name_r))
		return true;
	
	$cache_mtime = filemtime($cache_name);
		
	//最終更新ファイルと比較
	if( !file_exists(CACHE_DIR.QHM_LASTMOD) || $cache_mtime < filemtime(CACHE_DIR.QHM_LASTMOD) )
		return true;
	
	//バージョンアップされたら、とにかくキャッシュは再構築
	if( $cache_mtime < filemtime(LIB_DIR.'init.php') )
		return true;

	//テンプレート構造
	if( $cache_mtime < filemtime(LIB_DIR.'qhm_template.php') )
		return true;
		
	//pukiwiki.ini.phpと比較（デザイン変更に対応）
	if ( $cache_mtime < filemtime(INI_FILE) )
		return true;
		
	return false;
}

/*
* キャッシュを生成し、保存し、出力できるHTMLコードを返却する
*
* 引数 : $page=ページ名、 $body_str=キャッシュする情報
* 戻り値 : 動的プラグインを実行した出力できる結果
*/
function create_wiki_cache($page, $body_str)
{
	global $cache_rel_pages, $create_cache_mode, $pkwk_dtd;
		
	$wiki_cache_name = CACHE_DIR.encode($page).'.tmp';
	$cache_rel_name = CACHE_DIR.encode($page).'.tmpr';
	
	//コンテンツ部分のHTMLをキャッシュに出力
	file_put_contents($wiki_cache_name,$body_str);
	
	//キャッシュ更新に関係するページ名を出力[line: 0]
	file_put_contents($cache_rel_name, implode(',', $cache_rel_pages)."\n");

	//キャッシュできない関数で、事前に実行して置換する関数呼び出しを登録[line: 1]
	$rel_str = get_dynamic_plugin_str();
	file_put_contents($cache_rel_name, $rel_str."\n", FILE_APPEND);
	
	//出力文字エンコード [line: 2]
	file_put_contents($cache_rel_name, $pkwk_dtd.','.CONTENT_CHARSET.','.TEMPLATE_ENCODE."\n", FILE_APPEND);
	
	//キャッシュでも実行できるプラグインを実行する	
	$create_cache_mode = false;
	$body_str = replace_dynamic_plugin($rel_str, $body_str );	
	
	return $body_str;
}

function get_dynamic_plugin_str(){
	global $cache_rel_funcs;
	
	$tmp_arr = array();
	foreach($cache_rel_funcs as $f){
		$tmp_arr[] = $f['file'].'##SEP##'.$f['func'];
	}
	
	return implode('##SEP##', $tmp_arr);
}

function output_wiki_cache($page)
{
	$cache_name = CACHE_DIR.encode($page).'.tmp';
	
	// キャッシュでも実行できるプラグインを実行する	
	$cache_param = explode("\n", file_get_contents(CACHE_DIR.encode($page).'.tmpr') );
	$body = replace_dynamic_plugin($cache_param[1], file_get_contents($cache_name) );
		
	// headerの出力
	$tmp_arr = explode(',', $cache_param[2]);
	$pkwk_dtd = $tmp_arr[0];
	$content_charset = $tmp_arr[1];
	$encode = $tmp_arr[2];
		
	qhm_output_dtd($pkwk_dtd, $content_charset, $encode);
	echo $body;
}

//##SEP##で区切られたプラグイン実行と置き換え文字の文字列を引数にとる
function replace_dynamic_plugin($str, $body, $use_global=false)
{

	if($use_global){
		$str = get_dynamic_plugin_str();
	}

	$rel_funcs = array();
	$srh = array();
	$rep = array();

	//pluginの呼び出しが２回されてしまうので、無駄に２度のデータが入っている
	//そのことを吸収しつつ、プラグインを１度だけ実行するように気を付けるために、ややこしい	
	$arr = explode("##SEP##", $str);
	$cnt = count($arr);
	
	//ダイナミックなプラグインがなければ、何もしない
	if($cnt < 2)
		return $body;
	
	for($i=0; $i<$cnt; $i+=2)
	{
		$plg_name = $arr[$i];
		$fnc_name = $arr[$i+1];
		
		if(! isset($rel_funcs[ $plg_name ]) )
		{
			$rel_funcs[ $plg_name ] = array();
			require_once('plugin/'.$plg_name.'.inc.php');
		}
		
		if(! in_array($fnc_name, $rel_funcs) )
		{
			$rel_funcs[ $plg_name ] = $fnc_name;
			$srh[] = '<!-- #'.$fnc_name.'# -->';
			$rep[] = eval('return '.$fnc_name);	
		}
	}
	
	return str_replace($srh, $rep, $body);
}

?>
