<?php
/***
* 自分のためだけのmail送信コンポーネント
*
* ※ありとあらゆる方法で、文字化けするので・・・・
*
*
*/
class SimpleMail{

	/**
	* public
	*/
	var $language = 'Japanese';
	var $encoding = 'UTF-8';
	var $from = array('name'=>"", 'email'=>"");
	var $return_path = '';
	var $reply_to = '';
	var $x_mailer = '';
	var $to = array('name'=>'', 'email'=>'');
	var $subject = '';
	var $host_path = '';
	
	var $searchkey = array (
		'<%id%>',
		'<%lastname%>',
		'<%firstname%>',
		'<%lastname_kana%>',
		'<%firstname_kana%>',
		'<%zipcode%>',
		'<%state%>',
		'<%city%>',
		'<%address1%>',
		'<%address2%>',
		'<%birthday%>',
		'<%email%>',
		'<%tel%>',
		'<%enc_lastname%>',
		'<%enc_firstname%>',
		'<%enc_email%>',
		'<%password%>',
		'<%cancel%>',
	);


	var $searchkey_name = array (
		'ID',
		'山田(姓)',
		'太郎(名)',
		'よみ(姓)',
		'よみ(名)',
		'郵便番号',
		'都道府県',
		'市町村',
		'住所１',
		'住所２',
		'生年月日',
		'メールアドレス',
		'電話番号',
		'エンコード(姓)',
		'エンコード(名)',
		'エンコード(メール)',
		'パスワード',
		'メール配信の停止URL',
	);

	
	function set_params($name, $email, $x_mailer='Commu System Mail Sender'){
		$this->from = array(
			'name'=> $name,
			'email'=> $email
		);
		$this->return_path = $email;
		$this->reply_to = $email;
		$this->x_mailer = $x_mailer;
	}
	
	function set_from($name, $email, $x_mailer='Commu System Mail Sender'){
		$this->set_params($name, $email, $x_mailer);
	}
	
	function set_to($name, $email){
		$this->to = array('name'=>$name, 'email'=>$email);
	}
	
	function set_subject($subject){
		$this->subject($subject);
	}
		
	function send($body){
	
//		pr($body);
		
		mb_language($this->language);
		mb_internal_encoding($this->encoding);
		
		$from_name = $this->from['name'];
		$from_adr = $this->from['email'];
		$rpath = ($this->return_path=='') ? $from_adr : $this->return_path;
		$repto = ($this->reply_to=='') ? $from_adr : $this->reply_to;
		$xmailer = ($this->x_mailer=='') ? "PHP/" . phpversion() : $this->x_mailer;
		$to_name = $this->to['name'];
		$to_adr = $this->to['email'];
		
		$headers =  "MIME-Version: 1.0 \n".
					"From: ".mb_encode_mimeheader(mb_convert_encoding($from_name,"ISO-2022-JP","AUTO"))."<{$from_adr}>"."\n".
					"Reply-To: {$repto}"."\n".
					"Content-Type: text/plain;charset=ISO-2022-JP\n".
					"X-Mailer: {$xmailer}";
		$to = mb_encode_mimeheader($to_name)."<$to_adr>";
		$subject = ($this->subject=='') ? '件名なし' : $this->subject;
		$body = str_replace("\r", "", $body);
		$body = mb_convert_kana($body, "KV");
		$body = mb_convert_encoding($body, "ISO-2022-JP","AUTO");
		
		$sendmail_params  = "-f $from_adr";
		
		if( ini_get('safe_mode') ){
			mb_send_mail($to_adr, $subject, $body, $headers);		
		}
		else{
			mb_send_mail($to_adr, $subject, $body, $headers, $sendmail_params);
		}
	}
	
	function replace_send($search, $replace, $body){
		if( count($search) == count($replace) ){
			
			$newserach = array();
			$cnt = 0;
			foreach($search as $value){
				$newsearch[$cnt] = '/'.$value.'/';
				$cnt++;
			}
		
			$body = preg_replace($newsearch, $replace, $body);
			$this->subject = preg_replace($newsearch, $replace, $this->subject);
		}
		$this->send($body);
	}
	
	/**
	*
	* 文字の置換を行う
	*/
	function replace_demo($body, $color="red"){
		$replace = array();
		foreach($this->searchkey_name as $value){
			$replace[] = '<span style="color:'.$color.'">'.$value.'</span>';
		}
		
		$body = str_replace($this->searchkey, $replace, $body);
				
		return $body;
	}

	/*****************
	 * mksearch : メール差し込み機能（検索用データ作成）
	 * [IN]  $user : ユーザー情報配列 <%{field name}%>
	 * [OUT] 検索配列
	 */
	function mksearch($user) {
		$ret = array();
		foreach ($user as $key => $val) {
			if (!is_array($val)) {
				$ret[] = "<%$key%>";
			}
		}

		//名前、メールアドレスは、URLエンコード
		$ta = array('lastname','firstname','email');
		foreach ($ta as $val){
			if (isset($user[$val])) {
				$ret[] = "<%enc_$val%>";
			}
		}
		
		//メール配信の停止を追加
		$ret[] = '<%cancel%>';

		return $ret;
	}

	/*****************
	 * mkreplace : メール差し込み機能（置き換え用データ作成）
	 * [IN]  $user : ユーザー情報配列
	 * [OUT] 置き換え配列
	 */
	function mkreplace($user) {
		$ret = array();
		foreach ($user as $key => $val) {
			if (!is_array($val)) {
				//有効期限は、日付をセット（保存されているのがタイムスタンプのため）
				if ($key == 'expiration') {
					if ($val != '') {
						$val = date('Y-m-d', $val);
					}
				}
				$val = ($val == "") ? "" : $val;
				$ret[] = $val;
			}
		}
		
		//名前、メールアドレスは、URLエンコード
		$ta = array('lastname','firstname','email');
		foreach ($ta as $val){
			if (isset($user[$val])) {
				$ret[] = rawurlencode($user[$val]);
			}
		}
		
		//メール配信の停止をエンコード
		$cancelurl = $this->host_path.'cancel.php?code='. commu_encrypt($user['id'].','.$user['email']);
		$ret[] = $cancelurl;

		return $ret;
	}

	function hello(){
		echo 'Hello! This is SimpleMail Library!!';
	}
}


?>