<?php
// PukiWiki - Yet another WikiWikiWeb clone
// $Id: comment2.inc.php,v 1.36 2006/01/28 14:54:51 teanan Exp $
// Copyright (C)
//   2002-2005 PukiWiki Developers Team
//   2001-2002 Originally written by yu-ji
// License: GPL v2 or (at your option) any later version
//
// Comment plugin

define('PLUGIN_COMMENT2_DIRECTION_DEFAULT', '1'); // 1: above 0: below
define('PLUGIN_COMMENT2_SIZE_MSG',  70);
define('PLUGIN_COMMENT2_SIZE_NAME', 15);

// ----
define('PLUGIN_COMMENT2_FORMAT_MSG',  '$msg');
define('PLUGIN_COMMENT2_FORMAT_NAME', '$name');
define('PLUGIN_COMMENT2_FORMAT_NOW',  '&new{$now};');
define('PLUGIN_COMMENT2_FORMAT_STRING', "\x08MSG\x08 -- \x08NAME\x08 \x08NOW\x08");
define('PLUGIN_COMMENT2_AUTH_MSG1', '認証コード');
define('PLUGIN_COMMENT2_AUTH_MSG2', '認証コードを入力してください');

function plugin_comment2_action()
{
	global $script, $vars, $now, $_title_updated, $_no_name;
	global $_msg_comment_collided, $_title_comment_collided;

	if (PKWK_READONLY) die_message('PKWK_READONLY prohibits editing');

//	if (! isset($vars['msg'])) return array('msg'=>'', 'body'=>''); // Do nothing

	$vars['msg'] = str_replace("\n", '&br;', $vars['msg']); // Cut LFs
	$head = '';
	$match = array();
	if (preg_match('/^(-{1,2})-*\s*(.*)/', $vars['msg'], $match)) {
		$head        = & $match[1];
		$vars['msg'] = & $match[2];
	}
	if ($vars['msg'] == '') return array('msg'=>'', 'body'=>''); // Do nothing

	$comment2  = str_replace('$msg', $vars['msg'], PLUGIN_COMMENT2_FORMAT_MSG);
	if(isset($vars['name']) || ($vars['nodate'] != '1')) {
		$_name = (! isset($vars['name']) || $vars['name'] == '') ? $_no_name : $vars['name'];
		$_name = ($_name == '') ? '' : str_replace('$name', $_name, PLUGIN_COMMENT2_FORMAT_NAME);
		$_now  = ($vars['nodate'] == '1') ? '' :
			str_replace('$now', $now, PLUGIN_COMMENT2_FORMAT_NOW);
		$comment2 = str_replace("\x08MSG\x08",  $comment2, PLUGIN_COMMENT2_FORMAT_STRING);
		$comment2 = str_replace("\x08NAME\x08", $_name, $comment2);
		$comment2 = str_replace("\x08NOW\x08",  $_now,  $comment2);
	}
	$comment2 = '-' . $head . ' ' . $comment2;

	$postdata    = '';
	$comment2_no  = 0;
	$above       = (isset($vars['above']) && $vars['above'] == '1');
	foreach (get_source($vars['refer']) as $line) {
		if (! $above) $postdata .= $line;
		if (preg_match('/^#comment2/i', $line) && $comment2_no++ == $vars['comment2_no']) {
			if ($above) {
				$postdata = rtrim($postdata) . "\n" .
					$comment2 . "\n" .
					"\n";  // Insert one blank line above #commment, to avoid indentation
			} else {
				$postdata = rtrim($postdata) . "\n" .
					$comment2 . "\n"; // Insert one blank line below #commment
			}
		}
		if ($above) $postdata .= $line;
	}

	$title = $_title_updated;
	$body = '';
	if (md5(@join('', get_source($vars['refer']))) != $vars['digest']) {
		$title = $_title_comment_collided;
		$body  = $_msg_comment_collided . make_pagelink($vars['refer']);
	}

	if($vars['authcode_master'] === $vars['authcode']){
		$noupdate = $vars['noupdate']==1 ? true : false;
		page_write($vars['refer'], $postdata, $noupdate);
	}
	else{
		$vars['comment2_error'] = 'error!!!';
	}
	
	$retvars['msg']  = $title;
	$retvars['body'] = $body;
	
	
	$vars['page'] = $vars['refer'];

	return $retvars;
}

function plugin_comment2_convert()
{
	global $vars, $digest, $_btn_comment, $_btn_name, $_msg_comment;
	static $numbers = array();
	static $comment2_cols = PLUGIN_COMMENT2_SIZE_MSG;
	$plugin_comment2_auth = true;

	$s_msg = $s_name = "";

	if (PKWK_READONLY) return ''; // Show nothing

	if (! isset($numbers[$vars['page']])) $numbers[$vars['page']] = 0;
	$comment2_no = $numbers[$vars['page']]++;

	$options = func_num_args() ? func_get_args() : array();
	if (in_array('noname', $options)) {
		$nametags = '<label for="_p_comment2_comment2_' . $comment2_no . '">' .
			$_msg_comment . '</label>';
	} else {
		if(isset($vars['comment2_error'])){
			$s_name = htmlspecialchars($vars['name']);
		}
		$nametags = '<label for="_p_comment2_name_' . $comment2_no . '">' .
			$_btn_name . '</label>' .
			'<input type="text" name="name" id="_p_comment2_name_' .
			$comment2_no .  '" size="' . PLUGIN_COMMENT2_SIZE_NAME .
			'" value="'.$s_name.'" />' . "\n";
	}
	$nodate = in_array('nodate', $options) ? '1' : '0';
	$noupdate = in_array('noupdate', $options) ? '1' : '0';
	$above  = in_array('above',  $options) ? '1' :
		(in_array('below', $options) ? '0' : PLUGIN_COMMENT2_DIRECTION_DEFAULT);
	if( in_array('textarea', $options) ){
		$area = isset($options[1]) && is_numeric($options[1]) ? $options[1] : 6;
	}
	else{
		$area = 0;
	}


	$authcode = '' . rand(0,9) . rand(0,9) . rand(0,9) . rand(0,9);
	$authcode_msg = '<span id="coment2_auth_msg_no_'.$comment2_no.
		'" style="font-size:11px;$1">$2('.$authcode.')
		<input type="text" name="authcode" value="" size="4" /></span>';
	
	if(isset($vars['comment2_error'])){
		$authcode_msg = str_replace('$2', PLUGIN_COMMENT2_AUTH_MSG2, str_replace('$1','color:red;',$authcode_msg));
		$s_msg = htmlspecialchars( str_replace('&br;', "\n", $vars['msg']) );
	}
	else{
		$authcode_msg = str_replace('$2', PLUGIN_COMMENT2_AUTH_MSG1, str_replace('$1','',$authcode_msg));
	}
	
	if($area){
		$input_area = '<br /><textarea name="msg" id="_p_comment2_comment2_'.$comment2_no.'" style="width:90%;" rows="'.$area.'">'
				.$s_msg.'</textarea>';
	}
	else{
		$input_area = '<input type="text"   name="msg" id="_p_comment2_comment2_'
				.$comment2_no.'" size="'.$comment2_cols.'" value="'.$s_msg.'" />';		
	}
	
	$script = get_script_uri();
	$s_page = htmlspecialchars($vars['page']);
	$string = <<<EOD
<br />
<form action="$script" method="post">
 <div>
  <input type="hidden" name="plugin" value="comment2" />
  <input type="hidden" name="refer"  value="$s_page" />
  <input type="hidden" name="comment2_no" value="$comment2_no" />
  <input type="hidden" name="nodate" value="$nodate" />
  <input type="hidden" name="above"  value="$above" />
  <input type="hidden" name="digest" value="$digest" />
  <input type="hidden" name="noupdate" value="$noupdate" />
  <input type="hidden" name="authcode_master" value="{$authcode}" />
  $nametags
  $authcode_msg
  $input_area
  <input type="submit" name="comment2" value="$_btn_comment" />
 </div>
</form>
EOD;

	return $string;
}
?>
