<?php
// $Id: dump.inc.php,v 1.37 2006/01/12 01:01:35 teanan Exp $
//
// Remote dump / restore plugin
// Originated as tarfile.inc.php by teanan / Interfair Laboratory 2004.

//zip.lib.php を読み込む
require_once(LIB_DIR. 'zip.lib.php');

//zip.lib.php を拡張する
class zipfile2 extends zipfile{

	function addDir($dir, $filter = false, $namedecode = false) {
		//最後のスラッシュを削除
		$dir = rtrim($dir, '/');
//		$dir = ($dir{strlen($dir)-1}=='/') ? substr($dir, 0, strlen($dir)-1) : $dir;
		
		if (!file_exists($dir) || !is_dir($dir)) {
			return;
		}
		
		$count = 0;
		$dhandle = opendir($dir);
		if ($dhandle) {
			while (false !== ($fname = readdir($dhandle))) {
		
				if (is_dir( $dir.'/'.$fname )) {
					if (substr($fname, 0, 1) != '.')
						$count += $this->addDir("$dir/$fname", $filter);
				} else {
					if((!$filter || preg_match("/$filter/", $fname)) && $fname != '.' && $fname != '..')
					{
						$filename = $dir. '/'. $fname;
						$handle = fopen($dir.'/'.$fname, "rb");
						$targetFile = fread($handle, filesize($filename));
						fclose($handle);
						if ($namedecode) {
							$filename = plugin_dump_decodename($filename);
						}
						$this->addFile($targetFile, './'.$filename);
						$count++;
					}
				}
			}
			closedir($dhandle);
		}
		return $count;
	
	}
	
	function download($filename) {
		header("Content-Type: application/octet-stream");
		header("Content-Disposition: attachment; filename={$filename}");
		echo $this->file();
	}
}


/////////////////////////////////////////////////
// User defines

// Allow using resture function
define('PLUGIN_DUMP_ALLOW_RESTORE', TRUE); // FALSE, TRUE

// ページ名をディレクトリ構造に変換する際の文字コード (for mbstring)
define('PLUGIN_DUMP_FILENAME_ENCORDING', 'SJIS');

// 最大アップロードサイズ
define('PLUGIN_DUMP_MAX_FILESIZE', 4024); // Kbyte

/////////////////////////////////////////////////
// Internal defines

// Action
define('PLUGIN_DUMP_DUMP',    'dump');    // Dump & download
define('PLUGIN_DUMP_RESTORE', 'restore'); // Upload & restore
define('PLUGIN_DUMP_FULL',    'full');    // Dump & download

global $_STORAGE;

// DATA_DIR (wiki/*.txt)
$_STORAGE['DATA_DIR']['add_filter']     = '^[0-9A-F]+\.txt';
$_STORAGE['DATA_DIR']['extract_filter'] = '^((?:[0-9A-F])+)(\.txt){0,1}';

// UPLOAD_DIR (attach/*)
$_STORAGE['UPLOAD_DIR']['add_filter']     = '^[0-9A-F_]+';
$_STORAGE['UPLOAD_DIR']['extract_filter'] = '^((?:[0-9A-F]{2})+)_((?:[0-9A-F])+)';

// BACKUP_DIR (backup/*.gz)
$_STORAGE['BACKUP_DIR']['add_filter']     = '^[0-9A-F]+\.gz';
$_STORAGE['BACKUP_DIR']['extract_filter'] =  '^((?:[0-9A-F])+)(\.gz){0,1}';

// SWFU_DIR (swfu/d/*)
$_STORAGE['SWFU_DIR']['add_filter']     = '^[-_.+a-zA-Z0-9]+';
$_STORAGE['SWFU_DIR']['extract_filter'] =  '^([-_.+a-zA-Z0-9]+)';


/////////////////////////////////////////////////
// プラグイン本体
function plugin_dump_action()
{
	global $style_name, $script;
	
	$style_name = '..';
	$back_url = '<p><a href="'.$script.'">QHMトップ</a> &gt; <a href="'.$script.'?cmd=qhmsetting">設定一覧</a> &gt; here</p>';

    $editable = ss_admin_check();
	if(!$editable){
		return array('msg' => 'バックアップ', 'body' => '<p>このページは、管理者のみ利用できます</p>');
	}

	global $vars;

	if (PKWK_READONLY) die_message('PKWK_READONLY prohibits this');

	$pass = isset($_POST['pass']) ? $_POST['pass'] : NULL;
	$act  = isset($vars['act'])   ? $vars['act']   : NULL;

	$body = '';

	if ($pass !== NULL) {
		if (! pkwk_login($pass)) {
			$body = "<p><strong>パスワードが違います。</strong></p>\n";
		} else {
			switch($act){
			case PLUGIN_DUMP_DUMP:
				$body = plugin_dump_download();
				break;
			case PLUGIN_DUMP_RESTORE:
				$retcode = plugin_dump_upload();
				if ($retcode['code'] == TRUE) {
					$msg = 'アップロードが完了しました';
				} else {
					$msg = 'アップロードに失敗しました';
				}
				$body .= $retcode['msg'];
				return array('msg' => $msg, 'body' => $back_url.$body);
				break;
			case PLUGIN_DUMP_FULL:
				$body = plugin_dump_download_full();
				break;
			}
		}
	}

	// 入力フォームを表示
	$body .= plugin_dump_disp_form();

	$msg = '';
	if (PLUGIN_DUMP_ALLOW_RESTORE) {
		$msg = 'dump & restore';
	} else {
		$msg = 'dump';
	}

	return array('msg' => $msg, 'body' => $back_url.$body);
}


function plugin_dump_decodename($name) {

	$dirname  = dirname(trim($name)) . '/';
	$filename = basename(trim($name));
	if (preg_match("/^((?:[0-9A-F]{2})+)_((?:[0-9A-F]{2})+)/", $filename, $matches)) {
		// attachファイル名
		$filename = decode($matches[1]) . '/' . decode($matches[2]);
	} else {
		$pattern = '^((?:[0-9A-F]{2})+)((\.txt|\.gz)*)$';
		if (preg_match("/$pattern/", $filename, $matches)) {
			$filename = decode($matches[1]) . $matches[2];

			// 危ないコードは置換しておく
			$filename = str_replace(':',  '_', $filename);
			$filename = str_replace('\\', '_', $filename);
		}
	}
	$filename = $dirname . $filename;
	// ファイル名の文字コードを変換
	if (function_exists('mb_convert_encoding'))
		$filename = mb_convert_encoding($filename, PLUGIN_DUMP_FILENAME_ENCORDING);


	return $filename;
}


/////////////////////////////////////////////////
// ファイルのダウンロード
function plugin_dump_download()
{
	global $vars, $_STORAGE;

	// アーカイブの種類
	$arc_kind = ($vars['pcmd'] == 'tar') ? 'tar' : 'tgz';

	// ページ名に変換する
	$namedecode = isset($vars['namedecode']) ? TRUE : FALSE;

	// バックアップディレクトリ
	$bk_wiki   = isset($vars['bk_wiki'])   ? TRUE : FALSE;
	$bk_attach = isset($vars['bk_attach']) ? TRUE : FALSE;
	$bk_backup = isset($vars['bk_backup']) ? TRUE : FALSE;
	$bk_swfu   = isset($vars['bk_swfu'])   ? TRUE : FALSE;

	$filecount = 0;
	$zip = new zipfile2();
	$zipfile = 'qhmbk_'.date("Ymd"). '.zip';

	if ($bk_wiki)   $filecount += $zip->addDir(DATA_DIR,   $_STORAGE['DATA_DIR']['add_filter'],   $namedecode);
	if ($bk_attach) $filecount += $zip->addDir(UPLOAD_DIR, $_STORAGE['UPLOAD_DIR']['add_filter'], $namedecode);
	if ($bk_backup) $filecount += $zip->addDir(BACKUP_DIR, $_STORAGE['BACKUP_DIR']['add_filter'], $namedecode);
	if ($bk_swfu)   $filecount += $zip->addDir('swfu/d',   $_STORAGE['SWFU_DIR']['add_filter'],   $namedecode);


	if ($filecount === 0) {
		return '<p><strong>ファイルがみつかりませんでした。</strong></p>';
	} else {
		// ダウンロード
		$zip->download($zipfile);
		exit;
	}
}

/////////////////////////////////////////////////
// ファイルのダウンロード
function plugin_dump_download_full()
{

	error_reporting(E_ERROR | E_PARSE);
	
	global $vars;

	if( isset($vars['_p_dump_memlimit']) ){
		
		if( is_numeric($vars['_p_dump_memlimit_value']) )
		{
				ini_set("memory_limit", $vars['_p_dump_memlimit_value']."M");
		}
		else{
			return 'エラー：不正なメモリの値が設定されました';
		}
	}


	// バックアップディレクトリ
	$bk_dirs = array(
		UPLOAD_DIR, COUNTER_DIR, CACHE_DIR, DIFF_DIR, 
		IMAGE_DIR, BACKUP_DIR, LIB_DIR, PLUGIN_DIR, 
		DATA_DIR, 'js/', 'swfu/', 'fwd3/', 'fwd/', 'fwd2/', 'skin/', 'trackback/'
	);
	
	// バックアップファイル
	$bk_files = array(
		'COPYING.txt','default.ini.php','en.lng.php','index.php',
		'INSTALL.txt','ja.lng.php','keitai.ini.php','pukiwiki.ini.php','pukiwiki.ini.txt',
		'qhm_access.ini.txt','qhm_users.ini.txt','README.en.txt','README.txt',
		'rules.ini.php','UPDATING.en.txt','UPDATING.txt'
	);
	
	$bk_fname = 'qhmbk_'.date("Ymd").'.zip';

	//zipファイルの作成　(メモリーオーバーをする危険あり)
	$zip = new zipfile2();
	foreach($bk_dirs as $dir){
		$zip->addDir($dir);
		//zip_add_dir($dir, $zipFile, 'qhmbk_');
	}
	
	foreach($bk_files as $file){
		if( file_exists($file) )
			$zip->addFile(file_get_contents($file), $file);
	}
	
	$dump_buffer = $zip->file();
	
	header("Content-Type: application/octet-stream");
	header("Content-Disposition: attachment; filename={$bk_fname}");
	echo $dump_buffer;
	
	exit;
}



/////////////////////////////////////////////////
// ファイルのアップロード
function plugin_dump_upload()
{
	global $vars, $_STORAGE;

	if (! PLUGIN_DUMP_ALLOW_RESTORE)
		return array('code' => FALSE , 'msg' => 'Restoring function is not allowed');

	$filename = $_FILES['upload_file']['name'];
	$matches  = array();
	$arc_kind = FALSE;
	if(!preg_match('/\.zip$/', $filename, $matches)){
		die_message('Invalid file type');
	}

	if ($_FILES['upload_file']['size'] >  PLUGIN_DUMP_MAX_FILESIZE * 1024)
		die_message('Max file size exceeded: ' . PLUGIN_DUMP_MAX_FILESIZE . 'KB');

	//require unzip
	require_once(LIB_DIR. 'unzip.lib.php');
	
	// Create a temporary tar file
	$uploadfile = tempnam(realpath(CACHEQHM_DIR), 'zip_uploaded_');
	
	if (!move_uploaded_file($_FILES['upload_file']['tmp_name'], $uploadfile)) {
		@unlink($uploadfile);
		die_message('ファイルがみつかりませんでした。');
	}
	$unzip = new SimpleUnzip($uploadfile);
	

	$files = array();
	$len = $unzip->Count();
	for ($i = 0; $i < $len; $i++) {
		$name = $unzip->GetName($i);
		$path = $unzip->GetPath($i);
		//path をディレクトリにする: ./ で始まる場合、それを除去
		$dir = basename($path);
		//swfu/d
		if ($dir == 'd') {
			$dir = strpos($path, 'swfu/d') !== FALSE? 'swfu/d': '';
		}
		
		switch($dir) {
			case 'wiki':
				$stokey = 'DATA_DIR';
				break;
			case 'attach':
				$stokey = 'UPLOAD_DIR';
				break;
			case 'backup':
				$stokey = 'BACKUP_DIR';
				break;
			case 'swfu/d':
				$stokey = 'SWFU_DIR';
				break;
			default:
				$stokey = '';		
		}
		
		$filter = isset($_STORAGE[$stokey]['extract_filter'])? $_STORAGE[$stokey]['extract_filter']: '';
		if ($filter && preg_match("/$filter/", $name)) {
			$uzfile = $path. '/'. $name;
			$files[] = $uzfile;

			$data = $unzip->GetData($i);
			$dlen = strlen($data);
			if ($fp = fopen($uzfile, "wb")) {
				fwrite($fp, $data, $dlen);
				fclose($fp);
				chmod($uzfile, 0666);
			} else {
				echo '<error>', $name, ' is cannot opened!</error>';
			}
		}
	}


	if (empty($files)) {
		@unlink($uploadfile);
		return array('code' => FALSE, 'msg' => '<p>展開できるファイルがありませんでした。</p>');
	}

	$msg  = '<p><strong>展開したファイル一覧</strong><ul>';
	foreach($files as $name) {
		$msg .= "<li>$name</li>\n";
	}
	$msg .= '</ul></p>';

	@unlink($uploadfile);

	return array('code' => TRUE, 'msg' => $msg);
}


/////////////////////////////////////////////////
// 入力フォームを表示
function plugin_dump_disp_form()
{
	global $script, $defaultpage;

	$act_down = PLUGIN_DUMP_DUMP;
	$act_up   = PLUGIN_DUMP_RESTORE;
	$maxsize  = PLUGIN_DUMP_MAX_FILESIZE;
	$act_full = PLUGIN_DUMP_FULL;

	$data = <<<EOD
<span class="small">
</span>
<h2>バックアップ・リストア</h2>
<div style="border:1px #999 solid;background-color:#eee; padding:0px 1em;">
<p><b>注意事項</b><br />
<ul style="margin-left:8px">
<li>ファイル数が多い場合、ダウンロード開始まで時間がかかることがあります</li>
<li>ファイル数が多い場合、途中でエラーするときがあります（FTPソフトをお使い下さい)</li>
<li>設置されているサーバーによっては、エラーを表示し、動かない場合があります</li>
</ul>
</p>
</div>

<h3>フルバックアップ</h3>
<p>QHMシステムをすべて圧縮し、バックアップファイルをダウンロードします。<br />
※フルバックアップしたファイルは、FTPソフトでリストアしてください</p>
<form action="$script" method="post">
 <div>
  <input type="hidden" name="cmd"  value="dump" />
  <input type="hidden" name="page" value="$defaultpage" />
  <input type="hidden" name="act"  value="$act_full" />

<p><label for="_p_dump_adminpass_dump"><strong>管理者パスワード</strong></label>
  <input type="password" name="pass" id="_p_dump_adminpass_dump" size="12" />
  <input type="submit"   name="ok"   value="ダウンロード" />
</p>
<p style="margin-left:2em;"><input type="checkbox" name="_p_dump_memlimit"> メモリ使用量の制限を変更する <input type="text" size="4" name="_p_dump_memlimit_value" value="64" />MB<br />
※エラーがでて、動かないときに利用して下さい（一部サーバーでは使えません）</p>

 </div>
</form>
<br />

<h3>データのダウンロード</h3>
<form action="$script" method="post">
 <div>
  <input type="hidden" name="cmd"  value="dump" />
  <input type="hidden" name="page" value="$defaultpage" />
  <input type="hidden" name="act"  value="$act_down" />

<p>
	指定したフォルダをZip形式で圧縮します。
</p>
<p><strong>バックアップディレクトリ</strong>
<br />
  <input type="checkbox" name="bk_wiki" id="_p_dump_d_wiki" checked="checked" />
  <label for="_p_dump_d_wiki">wiki</label><br />
  <input type="checkbox" name="bk_attach" id="_p_dump_d_attach" />
  <label for="_p_dump_d_attach">attach</label><br />
  <input type="checkbox" name="bk_backup" id="_p_dump_d_backup" />
  <label for="_p_dump_d_backup">backup</label><br />
  <input type="checkbox" name="bk_swfu" id="_p_dump_d_swfu" />
  <label for="_p_dump_d_swfu">swfu/d</label><br />
</p>
<p><strong>オプション</strong>
<br />
  <input type="checkbox" name="namedecode" id="_p_dump_namedecode" />
  <label for="_p_dump_namedecode">エンコードされているページ名をディレクトリ階層つきのファイルにデコード
  (※リストアに使うことはできなくなります。また、一部の文字は '_' に置換されます)</label><br />
</p>
<p><label for="_p_dump_adminpass_dump"><strong>管理者パスワード</strong></label>
  <input type="password" name="pass" id="_p_dump_adminpass_dump" size="12" />
  <input type="submit"   name="ok"   value="OK" />
</p>
 </div>
</form>
EOD;

	if(PLUGIN_DUMP_ALLOW_RESTORE) {
		$data .= <<<EOD
<h3>データのリストア (*.zip)</h3>
<p style="color:red;font-size:.8em">
	※ バックアップファイルが古い拡張子（*.tgz, *.tar.gz) の人は<a href="$script?cmd=dump2">こちら</a>から
</p>
<form enctype="multipart/form-data" action="$script" method="post">
 <div>
  <input type="hidden" name="cmd"  value="dump" />
  <input type="hidden" name="page" value="$defaultpage" />
  <input type="hidden" name="act"  value="$act_up" />
<p><strong>[重要] 同じ名前のデータファイルは上書きされますので、十分ご注意ください。<br />
※フルバックアップしたファイルでは、リストアできません</strong></p>
<p><span class="small">
アップロード可能な最大ファイルサイズは、$maxsize KByte までです。<br />
</span>
  <label for="_p_dump_upload_file">ファイル:</label>
  <input type="file" name="upload_file" id="_p_dump_upload_file" size="40" />
</p>
<p><label for="_p_dump_adminpass_restore"><strong>管理者パスワード</strong></label>
  <input type="password" name="pass" id="_p_dump_adminpass_restore" size="12" />
  <input type="submit"   name="ok"   value="OK" />
</p>
 </div>
</form>
EOD;
	}

	return $data;
}


?>
