<?php
// PukiWiki - Yet another WikiWikiWeb clone.
// $Id: dwrite.inc.php,
//
// dwrite box plugin

/**
*
* 使い方 : 
*   &dwrite(passcode){表示する文言};
*
* インラインプラグイン ： 
*　　通常の場合 -- 単に、return しただけ
*　　編集モード -- 書き換え用フォームへのリンクを出力
*
* アクションプラグイン : 
*   
*   
*/

function plugin_dwrite_action()
{
	global $vars, $script;


	//error
	if($vars['page']==''){
		return array('msg'=>'Error', 'body'=>'<p>URLが不正です</p>');
	}

	if( $vars['mode'] == 'make' ){ //create mode 
		
		$template = $script.'?plugin=dwrite&page='.rawurlencode( $vars['page'] )
			.'&mode=write&code='.$vars['code'];
		$template_s = htmlspecialchars($template);
		
		$title = 'ダイレクト書き換え・設定画面';
		$contents = <<<EOD
<script type="text/javascript">
function gen_dwrite_code(val){
	var el = document.getElementById('dwrite_url');
	el.value = '{$template}&value='+encodeURIComponent(val);
}
</script>
<p style="text-align:left;font-weight:bold;">書き換えたい文字を入力して下さい<br />
<input type="text" size="40" id="dwrite_data" onkeyup="gen_dwrite_code(this.value);return false;" style="background-color:#ffc;" /></p>
<p style="text-align:left;">書き換え用URL<br />
<input type="text" size="40" id="dwrite_url" readonly="readonly" onclick="this.select();" />
</p>

<p style="text-align:left;">書き換え編集用URL<br />
<input type="text" size="40" id="dwrite_url" readonly="readonly" value="{$template_s}" onclick="this.select();" />
</p>


EOD;
		auth_catbody($title, $contents);
		exit;
	} //書き込み確認
	else if( $vars['mode'] == 'write' ){
	
		$code = $vars['code'];
		$rep = array(); $cnt=0;
		
		foreach( get_source($vars['page']) as $line){
		
			if( $res = plugin_dwrite_getContent($code, $line) )
			{
				$rep[$cnt] = $res;
				$cnt++;
			}
		}
		
		//error
		if($cnt==0){
			return array('msg'=>'Error', 'body'=>'<p>書き換える対象が見つかりません</p>');
		}
	

		$title = 'ダイレクト書き換え・確認';
		
		if( ! isset($vars['value']) ){
		
			$s_page = htmlspecialchars($vars['page']);
			$s_code = htmlspecialchars($vars['code']);
			
			$contents = <<<EOD
<p>以下に書き換えたい文字を入力して、確認ボタンを押して下さい。</p>
<form method="post" action="{$script}">
<input type="hidden" name="plugin" value="dwrite" />
<input type="hidden" name="page" value="{$s_page}" />
<input type="hidden" name="mode" value="write" />
<input type="hidden" name="code" value="{$s_code}" />
<input type="text" name="value" size="40" /> <input type="submit" name="ok" value="確認" />
</form>
EOD;
		
		}
		else{

			$s_page = htmlspecialchars($vars['page']);
			$s_code = htmlspecialchars($vars['code']);
			$s_value = htmlspecialchars( $vars['value'] );
		
			$tmp_str = '';
			foreach($rep as $v){
				$tmp_str .= '「'.$v.'」';
			}
			$contents = htmlspecialchars( $tmp_str.' を 「'.$vars['value'].'」 に、書き換えますか？' );

			$contents .= <<<EOD
<form method="post" action="{$script}">
<input type="hidden" name="plugin" value="dwrite" />
<input type="hidden" name="page" value="{$s_page}" />
<input type="hidden" name="mode" value="do_write" />
<input type="hidden" name="code" value="{$s_code}" />
<input type="hidden" name="value" value="{$s_value}" /> <input type="submit" name="ok" value=" 実行する " />
</form>
EOD;

		}
		
		
		auth_catbody($title, $contents);
		exit;
	
	}
	else if( $vars['mode'] == 'do_write' ){

		$code = $vars['code'];
		$ms = array();
		
		
		foreach( get_source($vars['page']) as $line){
		
			if( $res = plugin_dwrite_getContent($code, $line) )
			{
				$s = '&dwrite('.$code.'){'.$res.'};';
				$r = '&dwrite('.$code.'){'.$vars['value'].'};';
				
				$new_data .= str_replace($s, $r, $line);

			}
			else{
				$new_data .= $line;
			}
		}
						
		page_write($vars['page'], $new_data);

		$title = $vars['page'].' の書き換え';
		$url = $script.'?'.rawurlencode($vars['page']);
		$contents = <<<EOD
<p>書き換えました</p>
<p>確認するには、こちらを<a href="{$url}">クリック</a>してください</p>
EOD;
		auth_catbody($title, $contents);
		exit;

	}

	return array('msg'=>$title, 'body'=>$body);
}

function plugin_dwrite_inline()
{
	global $script, $vars,  $digest;
	static $number = array();

	$page = isset($vars['page']) ? $vars['page'] : '';
	
	// dwrite-box-id in the page
	

	if (func_num_args() != 2) return '#dwrite(): No arguments<br />' . "\n";

	$args     = func_get_args();
	$s_page   = htmlspecialchars($page);

	$code = $args[0];
	$text = $args[1];
	

    $editable = edit_auth($page, FALSE, FALSE);
	if($editable){	
		$href = $script.'?plugin=dwrite&page='.rawurlencode($page).'&code='
			.$code.'&mode=make&KeepThis=true&TB_iframe=true&height=450&width=650';
		$text = $text=='' ? '(空白)' : $text;
		return '<a href="'.$href.'" class="thickbox" style="border-bottom:1px dashed;color:inherit;">'.$text.'</a>';	
	}
	else{
		return $text;
	}
}

function plugin_dwrite_getContent($code, $line){
	$ms = array();
	if( preg_match('/&dwrite\('.$code.'\){(.*)};/', $line , $ms) )
	{
		$str = $ms[1];
		$len = strlen($str);
		$content = '';
		
		$stuck = 1;
		for($i=0; $i<$len; $i++){
						
			//stack trace
			if($str{$i} == '{'){
				$stuck++;
			}
			else if( $i+1<$len && $str{$i}.$str{$i+1} == '};'){
				$stuck--;
			}
			
			if($stuck==0)
				break;
			
			$content .= $str{$i};
		}
		
		if($content == '')
			return false;
		else
			return $content;
	}
	else{
		return false;
	}
}
?>
