<?php
// PukiWiki - Yet another WikiWikiWeb clone.
// $Id: formzu.inc.php,v 0.5 2006/06/26 15:04:08 henoheno Exp $
//
// Formzu inline view plugin

// Allow CSS instead of <font> tag
// NOTE: <font> tag become invalid from XHTML 1.1
define('PLUGIN_FORMZU_ALLOW_CSS', TRUE); // TRUE, FALSE

// ----
define('PLUGIN_FORMZU_USAGE', '&formzu(formurl,hight,width,align);');
define('PLUGIN_FORMZU_REGEX', '/^(#[0-9a-f]{3}|#[0-9a-f]{6}|[a-z-]+)$/i');

function plugin_formzu_convert()
{
	global $pkwk_dtd;

	$args = func_get_args();
	$args_cnt = count( $args );
	list($formurl, $hight, $width, $align) = array_pad($args, 4, '');

	if ($args_cnt < 3 || $args_cnt > 4) {  //correct args
		return PLUGIN_FORMZU_USAGE;
	}
	if ($args_cnt == 3) {
		$align = 'center'; 
	}

	if (PLUGIN_FORMZU_ALLOW_CSS === TRUE || ! isset($pkwk_dtd) || $pkwk_dtd == PKWK_DTD_XHTML_1_1) {
		return '<div style="text-align:' .$align. '"><iframe src="' . $formurl . '" frameborder="0" height="' . $hight . '" width="' . $width . '" style="margin:0px;text-align:' . $align . ';"><p>現在のブラウザは、フレームに対応しておりません。お手数ですが、<a href="' . $formurl . '">こちらをクリック</a>してください。</p></iframe></div>';
	} else {
		return 'Invalid argument';
	}
}
?>
