<?php

define('PLUGIN_QHMSETTING_LOGO_PATH', CACHE_DIR.'qhm_logo.');
define('PLUGIN_QHMSETTING_LOGO_PREV_PATH', CACHE_DIR.'qhm_logo_preview.');
define('PLUGIN_QHMSETTING_INI_SRC', 'pukiwiki.ini.txt');
define('QHM_USER_INI_FILE', 'qhm_users.ini.txt');
define('QHM_ACCESS_INI_FILE', 'qhm_access.ini.txt');
define('ALLOW_PASSWD_PATTERN', "/^[!-~]+$/");
if ((intval(phpversion()) > 4) && function_exists('stream_get_wrappers') && in_array('https', stream_get_wrappers())) {
	if ($fp = fopen('https://www.1st-easy-hp.com/', 'r')) {
		fclose($fp);
		define('PLUGIN_QHMSETTING_HTTP_SCHEME', 'https');
	} else {
		define('PLUGIN_QHMSETTING_HTTP_SCHEME', 'http');
	}
} else {
	define('PLUGIN_QHMSETTING_HTTP_SCHEME', 'http');
}
define('PLUGIN_QHMSETTING_CLUB_URL', PLUGIN_QHMSETTING_HTTP_SCHEME. '://www.1st-easy-hp.com/club/');//debug
define('QHMPRO_URL', 'https://www.1st-easy-hp.com/p/qhmpro/');
define('QHMPRO_HELP_LINK','<a href="'.QHMPRO_URL.'?%PAGE%"><img src="'.IMAGE_DIR.'settings_help.png" alt="ヘルプ" style="vertical-align:top" /></a>');

function plugin_qhmsetting_action()
{
	global $vars, $username, $style_name, $script;
	$title = '<p><a href="'.$script.'">QHMトップ</a> &gt; here</p>
<h2>Quick Homepage Maker 設定</h2>';
			
	//check admin, setting 
	if($username != $_SESSION['usr'] && $vars['phase']!='user2' && $vars['phase'] != 'script' && $vars['phase'] != 'sssavepath'){
		return array('msg'=>'アクセスできません', 'body'=>'<h2>アクセス制限</h2><p>このページは、管理者のみアクセスできます</p>');
	}
	if( !is_writable('pukiwiki.ini.php') ){
		return array('msg'=>'設定ファイルエラー', 'body'=>'<h2>エラー</h2><p>設定ファイル pukiwiki.ini.php に書き込めません。pukiwiki.ini.phpに書き込み権限(666)を設定して下さい。');
	}
	if( ! file_exists(PLUGIN_QHMSETTING_INI_SRC) ){
		return array('msg'=>'設定ファイルエラー', 'body'=>'<h2>エラー</h2><p>設定ファイル '.PLUGIN_QHMSETTING_INI_SRC.' が存在しません。</p>');
	}
	
	
	//POSTされている場合
	$phase = isset($vars['phase']) ? $vars['phase'] : 'default';
	$mode = isset($vars['mode']) ? $vars['mode'] : '';
	
	$func = 'plugin_qhmsetting_'.$phase.'_'.$mode;
	
	if( function_exists($func) ){
		$ret = '<p><a href="'.$script.'">QHMトップ</a> &gt; <a href="'.$script.'?cmd=qhmsetting">設定一覧</a> &gt; here</p>'.$func();
	}
	else{
		$ret = $title.plugin_qhmsetting_default();
	}

	$style_name = '..';
	return array('msg'=>"QHMサイト情報設定", 'body'=>$ret);
}

function plugin_qhmsetting_default()
{

	global $script, $other_plugins;
	
	$scrt = $script . '?plugin=qhmsetting&amp;mode=form&amp;phase=';

	$is_qhmpro = (isset($other_plugins) && count($other_plugins) > 0);

	$setlist = array(
		'design'    => array(
			'help' => 'ChangeDesign',
			'url'  => $scrt. 'design',
			'img'  => IMAGE_DIR. 'settings_design.png',
			'title' => 'デザインの変更',
			'subtitle' => 'ロゴ画像の設定、ロゴ部分の文字、テンプレートの設定を行います。',
			'limited' => false,
		),
		'info'      => array(
			'help' => 'SiteConfig',
			'url'  => $scrt. 'info',
			'img'  => IMAGE_DIR. 'settings_site.png',
			'title' => 'サイト情報の設定',
			'subtitle' => 'キーワード、サイト説明、ヘッダー、フッター、アクセス解析タグなどの設定を行います。',
			'limited' => false,
		),
		'admin'     => array(
			'help' => 'SetPassword',
			'url'  => $scrt. 'admin',
			'img'  => IMAGE_DIR. 'settings_user.png',
			'title' => 'ユーザー名、パスワードの変更',
			'subtitle' => '編集用のユーザー名、パスワードの設定を行います。',
			'limited' => false,
		),
		'useradmin' => array(
			'help' => 'UserAuthSetting',
			'url'  => $scrt. 'user',
			'img'  => IMAGE_DIR. 'settings_access.png',
			'title' => 'アクセス権限設定',
			'subtitle' => '特定のページにアクセス権限を設定し、アクセスできるユーザーを追加設定できます。',
			'limited' => true,
		),
		'clear'     => array(
			'help' => 'SettingCache',
			'url'  => $scrt. 'clear',
			'img'  => IMAGE_DIR. 'settings_cache.png',
			'title' => '高速化設定、キャッシュの初期化',
			'subtitle' => '表示を高速化するためのキャッシュ機能を設定、キャッシュの初期化、テンプレートを初期化を行います。',
			'limited' => false,
		),
		'back'      => array(
			'help' => 'EasyBackup',
			'url'  => $script. '?cmd=dump',
			'img'  => IMAGE_DIR. 'settings_backup.png',
			'title' => 'バックアップ',
			'subtitle' => 'QHMのバックアップをダウンロードできます。フルバックアップ、重要ファイルのみのバックアップなど可能です。',
			'limited' => true,
		),
		'counter'   => array(
			'help' => 'Counter',
			'url'  => $scrt. 'counter',
			'img'  => IMAGE_DIR. 'settings_counter.png',
			'title' => 'アクセスカウンター',
			'subtitle' => 'アクセスカウンターをリセットします。',
			'limited' => false,
		),
		'chmod'     => array(
			'help' => 'UserAuthSetting',
			'url'  => $scrt. 'chmod',
			'img'  => IMAGE_DIR. 'settings_file.png',
			'title' => 'ファイル権限設定',
			'subtitle' => '削除できない、FTPエラーが起こる原因である「ファイル権限」を設定、チェックします。',
			'limited' => true,
		),
		'mail'      => array(
			'help' => 'MailSetting',
			'url'  => $scrt. 'mail',
			'img'  => IMAGE_DIR. 'settings_mail.png',
			'title' => 'メール送信設定',
			'subtitle' => '送信メールサーバーを設定できます（SMTP送信、GoogleAppsなどの場合）',
			'limited' => true,
		),
		'close'     => array(
			'help' => 'SettingCloseSite',
			'url'  => $scrt. 'close',
			'img'  => IMAGE_DIR. 'settings_close.png',
			'title' => 'サイトの閉鎖',
			'subtitle' => 'QHMで作成された全ページを閉鎖します。閉鎖後は、管理者権限でログインすることで編集、閲覧が可能です。',
			'limited' => true,
		),
		'mobile'    => array(
			'help' => 'RedirectMobile',
			'url'  => $scrt. 'mobile',
			'img'  => IMAGE_DIR. 'settings_mobile.png',
			'title' => '携帯アクセス転送',
			'subtitle' => '携帯端末からのアクセスを携帯専用サイトなどに転送します。',
			'limited' => false,
		),
		'gmap'      => array(
			'help' => 'GoogleMapsKey',
			'url'  => $scrt. 'gmap',
			'img'  => IMAGE_DIR. 'settings_googlemap.png',
			'title' => 'Googleマップキー',
			'subtitle' => 'QHMでGoogleマップを使うためのキーを設定します。',
			'limited' => false,
		),
	);
	
	foreach ($setlist as $setname => $set) {
		$setlist[$setname]['help'] = $is_qhmpro? str_replace('%PAGE%', $set['help'], QHMPRO_HELP_LINK): '';
//--<LimitedSetting>--
		if ($set['limited']) {
			$setlist[$setname]['limited'] = false;
		}
//--</LimitedSetting>--
	}
//--<UnlimitBackup>--
	$setlist['back']['limited'] = false;
//--</UnlimitBackup>--


// HTML生成
	$html = <<<EOD
<p>Quick Homepage Makerの設定を行います。<br />
以下の項目から、変更したいものをクリックしてください。</p>

<style>
table#table-01 td {
    padding: 5px;
    border: 1px #E3E3E3 solid;
    width: 50%;
    vertical-align:top;
}
</style>

<table id="table-01">
EOD;

	$scnt = 0;
	foreach ($setlist as $set) {
		if ($scnt % 2 == 0) {
			$html .= '
	<tr>';
		}
	
		if ($set['limited']) {
			$html .= '
		<td style="background-color:#e0e0e0;"><p>
			<img src="'.$set['img'].'" alt="'.$set['title'].'" title="'.$set['title'].'" style="vertical-align:top;" />
			<span style="font-weight:bold;color:#666;">'. $set['title']. '</span>
		</p><span style="color:#888;">'.$set['subtitle'].'</span></td>';
		} else {
			$html .= '
		<td><p>
			<img src="'.$set['img'].'" alt="'.$set['title'].'" title="'.$set['title'].'" style="vertical-align:top;" />
			<a href="'.$set['url'].'" style="font-weight:bold;">'.$set['title'].'</a>'.$set['help'].'
		</p>'.$set['subtitle'].'</td>';
		}
	
		if ($scnt %2 == 1) {
			$html .= '
	</tr>';
		}
	
		$scnt++;
	}


	$html .= '
</table>
';

	return $html;

}

/**
* デザインの設定（フォームを表示）
*/
function plugin_qhmsetting_design_form($error = '')
{
	global $logo_image, $script, $vars, $style_name;
	global $enable_wp_theme, $enable_wp_theme_name, $wp_add_css;
	global $beforescript;
	global $other_plugins;

	// ヘルプリンク作成
	$is_qhmpro = (isset($other_plugins) && count($other_plugins) > 0);
	$hlp_design    = ($is_qhmpro) ? str_replace('%PAGE%','ChangeDesign',QHMPRO_HELP_LINK) : '';

	$params = plugin_qhmsetting_getparams();

	//現在の状態を格納
	if(isset($_SESSION['temp_design']) || isset($vars['design']))
	{
		$tmp_design_name = isset($vars['design']) ? $vars['design'] : $_SESSION['temp_design'];
		$wp_or_qhm = ( isset($vars['enable_wp_theme']) ? $vars['enable_wp_theme'] : $_SESSION['temp_enable_wp'] )
				 ? 'WordPressテーマ' : 'QHM専用';
		
		$body_msg = <<<EOD
<div style="color:#c00;border:1px solid #c00;background-color:#fcc;width:80%;margin:0 auto;padding:0 1em;text-align:center;">
<b>{$wp_or_qhm}の「{$tmp_design_name}」デザインのプレビュー状態です。</b>
</div>
EOD;
	}
	else{
		$wp_or_qhm = $enable_wp_theme ? 'WordPressテーマ' : 'QHM専用';
		$design_name = $enable_wp_theme ? $enable_wp_theme_name : $style_name;
		$body_msg = <<<EOD
<div style="color:#c00;border:1px solid #c00;background-color:#fcc;width:80%;margin:0 auto;padding:0 1em;text-align:center;">
<b>{$wp_or_qhm}の「{$design_name}」デザインを利用中です</b>
</div>
EOD;
	
	}
	
	//WordPressテーマのスキャン
	$hd = opendir('skin/wordpress/');
	$wp_dirs = array();
	while( $entry = readdir($hd) )
	{
		if(is_dir('skin/wordpress/'.$entry) && ($entry!='.') && ($entry!='..') && (file_exists('skin/wordpress/'.$entry.'/index.php')))
		{
			$wp_dirs[] = $entry;
		}
	}
	closedir($hd);
	sort($wp_dirs);

	//ここから
	$body = $body_msg;
	$body .= '<h2>デザインの設定'.$hlp_design.'</h2>';
	
	
	//======================================================
	//  QHM専用デザイン設定フォーム
	//======================================================
	$wp_index = count($wp_dirs) ? '<li><a href="#wordpress">WordPressテーマの設定</a></li>' : '';
	$body .= <<<EOD
<p>　QHM専用デザインを使う、もしくは、WordPressテンプレートを使うことができます。利用したいデザインは、事前に skin/hokukenstyle、もしくは、skin/wordpress にフォルダに分けて、アップロードしてください。</p>
<ul class="list1">
<li><strong>項目</strong>
	<ul class="list2">
		<li><a href="#qhmdesign">QHM専用デザインの設定</a></li>
		{$wp_index}
		<li><a href="#designpreview">プレビュー</a></li>
	</ul>
</li>
</ul>
EOD;
	$body .= '<br />';	
	$body .= ($error!='') ? '<p style="color:red">'.$error.'</p>' : '';

	$body .= '<h2 id="qhmdesign">QHM専用デザインの設定</h2>
<div style="border:2px solid #ccc;padding:1em;background-color:#fafafa">
';
	
	//デザインタイプの指定
	if( $params['style_type'] == 'text' )
	{
		$logotype_msg = 'テキストを使う設定';
		$img_tag = 'ロゴ画像なし';
	}
	else
	{
		$logotype_msg = '画像を使う設定';
		$img_tag = '<img src="'.$logo_image.'" style="width:450px" />';
	}
	
	$body .= <<<EOD
<form method="post" action="{$script}" enctype="multipart/form-data">
	<h3 id="logodesign">（１）ロゴ部分のデザインの設定</h3>
	<p><label><input type="radio" name="qhmsetting[style_type]" checked="checked" value="none" />変更なし (現在: {$logotype_msg})</label></p>
	<p><label><input type="radio" name="qhmsetting[style_type]" id="logoImageRadio" value="image" /> 画像を使う(500KB以下推奨)：</label><input type="file" name="imagefile" id="logoImageButton" /><br />
	<span style="font-size:80%">現在の設定：</span>{$img_tag}</p>
	<p><label><input type="radio" name="qhmsetting[style_type]" id="logoTextRadio" value="text" /> テキストを使う</label><br />
	<input type="text" name="qhmsetting[page_title]" id="logoTextInput" value="{$params['page_title']}" size="35" /></p>
EOD;


	//デザインテンプレートの指定
	$obj = dir(SKIN_DIR);
	$dirs = $dsgndirs = array();

	while( $entry = $obj->read() )
	{
		if(is_dir(SKIN_DIR.$entry) && ($entry!='.') && ($entry!='..') && (file_exists(SKIN_DIR.$entry.'/main.css')))
		{
			if (preg_match('/^(i_).*$/', $entry)) {
				$dsgndirs['1'][] = $entry;
			}
			else if (preg_match('/^(qd_).*$/', $entry)) {
				$dsgndirs['2'][] = $entry;
			}
			else if (preg_match('/^(org_).*$/', $entry)) {
				$dsgndirs['3'][] = $entry;
			}
			else if (preg_match('/^(qrs_).*$/', $entry)) {
				$dsgndirs['4'][] = $entry;
			}
			else if (preg_match('/^(g_).*$/', $entry)) {
				$dsgndirs['5'][] = $entry;
			}
			else {
				$dsgndirs['6'][] = $entry;
			}
		}
	}
	ksort($dsgndirs);
	foreach ($dsgndirs as $row) {
		sort($row);
		$dirs = array_merge($dirs,$row);
	}
	unset($dsgndirs);

	//======================================================
	//  デザイン選択フォーム
	//======================================================

	$body .= '<br /><h3>（２）デザインテンプレートの選択</h3>'."\n";
	$body .= '<div id="qhmdesignStatus"></div>'. "\n";
	$body .= '<p>以下から、デザインテンプレートを選択して下さい。</p>';
	
	$body .= '<table id="designList"><tr>';
	$dircnt = count($dirs);
	for ($i = 0; $i < $dircnt; $i++) {
		$dir = $dirs[$i];
		$thumb = file_exists(SKIN_DIR . $dir . '/thumbnail.png')? SKIN_DIR . $dir . '/thumbnail.png': SKIN_DIR . $dir . '/thumbnail.jpg';
		$ckd = ( $dir == $params['style_name'] ) ? ' checked="checked" class="currentStyle"' : '';
		$ckd_msg = $ckd=='' ? '' : ' (現在の設定)';
		$body .= '<td width="33%"><label>
	<img src="'.$thumb.'" alt="'.$dir.'サムネール" width="180" height="200" /><br />
	<input type="radio" name="qhmsetting[style_name]" value="'.$dir.'"'.$ckd.' />'.$dir.$ckd_msg.'
</label></td>
';
		if ($i % 3 == 2) {
			$body .= '</tr><tr>';
		}
	}
	$body .= '</tr></table>';
	
//--<GetQHMDesign>--
	//======================================================
	//  !デザイン取得
	//======================================================
	if (is_writable(SKIN_DIR)) {
		//jQuery と jQuery UI を読み込む
		$beforescript = '
<link type="text/css" href="http://ajax.googleapis.com/ajax/libs/jqueryui/1.7/themes/smoothness/jquery-ui.css" rel="stylesheet" />
<script type="text/javascript" src="http://www.google.com/jsapi"></script>
<script type="text/javascript">google.load("jquery", "1.3");google.load("jqueryui", "1.7")</script>
<script type="text/javascript" src="js/get_qhm_designs.js"></script>';

	if ((isset($other_plugins) && count($other_plugins) > 0)) {
		if ($fp = fopen(PLUGIN_QHMSETTING_CLUB_URL, 'rb')) {
			fclose($fp);
			$body .= '
	<p><a href="#" id="qhmDesignGetter">&gt;&gt;&gt; デザインテンプレートを取得</a></p>';
		} else {
			$body .= '
	<p><a href="'.QHMPRO_URL.'sys/" target="new">&gt;&gt;&gt;インストールシステムでデザインテンプレートを取得する</a><br /><span style="color:#f66">※このサーバーではQHMからデザインテンプレートを取得できません</span></p>';
		}
	}
	
	
		$body .= '
<div id="authDialog" style="display:none" title="北研クラブ認証">
	<div id="authStatus"></div>
	<table style="border:none;width:100%;">
		<tr>
			<th style="width:8em;text-align:left;white-space:nowrap">メールアドレス</th>
			<td><input type="text" name="email" id="email" size="20" style="width:90%" /></td>
		</tr>
		<tr>
			<th style="width:8em;text-align:left">パスワード</th>
			<td><input type="password" name="password" id="password" size="20" style="width:90%" /></td>
		</tr>
	</table>
	<input type="hidden" name="phase" value="club" />
	<input type="hidden" name="mode" value="auth" />
	<input type="hidden" name="from" value="design_form" />
	<input type="hidden" name="plugin" value="qhmsetting" />
	<input type="hidden" name="pcmd"   value="post" />
</div>
<div id="designDialog" style="display:none;"></div>
<div id="fragDialog" style="display:none;text-align:left;">
<a href="#i_001">[1]花柄</a><br />
<a href="#i_101">[2]ビジネス</a><br />
<a href="#i_201">[3]透明モダン</a><br />
<a href="#i_301">[4]ノート型</a><br />
<a href="#i_401">[5]アート系</a><br />
<a href="#i_501">[6]モダン・ポップ</a><br />
<a href="#i_601">[7]高級感</a><br />
<a href="#i_701">[8]シンプル・和</a><br />
<a href="#i_801">[9]ノート型2</a><br />
<a href="#g_green01">[-]標準デザイン</a>
</div>
';
	}
//--</GetQHMDesign>--
	
	$body .= '
<input type="hidden" name="phase" value="design" />
<input type="hidden" name="mode" value="confirm" />
<input type="hidden" name="from" value="design_form" />
<input type="hidden" name="plugin" value="qhmsetting" />
<input type="hidden" name="pcmd"   value="post" />
<input type="hidden" name="enable_wp_theme" value="0" />
<p style="text-align:center"><input type="submit" value="設定を確認する" style="font-size:16px" /></p>
</form>

';


//--<RemoveQHMDesign>--
	//======================================================
	//  デザイン削除フォーム
	//======================================================
	
	$showRemove = count($dirs) > 1;
	$body .= '<div id="qhmdesignremove_holder"'.($showRemove? '': ' style="display:none"').'>';
		$body .= <<<EOD
	<br /><hr style="border:1px dashed #888" >
	<h4 id="qhmdesignremove">デザインの削除</h4>
	<form method="post" action="{$script}">
EOD;
	$body .= '<p>';
		$body .= '<select name="qhmsetting[style_name]" id="removeSelector">';
		foreach($dirs as $dir){
			$ckd = ( $dir == $params['style_name'] ) ? true : false;
			$body .= $ckd?'': '<option value="'.$dir.'">'.$dir.'</option>';
		}
		$body .= '</select>';

		$body .= '
	<input type="hidden" name="phase" value="design" />
	<input type="hidden" name="mode" value="remove" />
	<input type="hidden" name="option" value="confirm" />
	<input type="hidden" name="from" value="design_form" />
	<input type="hidden" name="plugin" value="qhmsetting" />
	<input type="hidden" name="pcmd"   value="post" />
	<input type="submit" value="削除する" /></p>
	</form></div>
';



	$body .= '
</div>

';
//--</RemoveQHMDesign>--


//--<FTPAccess>--
	//======================================================
	//  !FTP接続フォーム
	//======================================================
	$body .= '
<div id="ftpDialog" style="display:none" title="FTP接続">
	<p>PHPがセーフモードで稼働しているため、FTP接続が必要です。このサーバーのFTPアカウントとパスワードを入力してください。</p>
	<div id="ftpStatus"></div>
	<table style="border:none;width:100%;">
		<tr>
			<th style="width:8em;text-align:left;white-space:nowrap">FTPアカウント</th>
			<td><input type="text" name="username" id="ftpusername" size="20" style="width:90%" /></td>
		</tr>
		<tr>
			<th style="width:8em;text-align:left">パスワード</th>
			<td><input type="password" name="password" id="ftppassword" size="20" style="width:90%" /></td>
		</tr>
		<tr id="ftpDirRow" style="display:none">
			<th style="width:8em;text-align:left">設置先フォルダ</th>
			<td>
				<input type="hidden" name="use_dir" value="0" id="ftpusedir" />
				<input type="text" name="dir" id="ftpdir" size="20" style="width:90%" /></td>
		</tr>
	</table>
	<input type="hidden" name="design_name" value="" />
	<input type="hidden" name="phase" value="ftp" />
	<input type="hidden" name="mode" value="access" />
	<input type="hidden" name="from" value="design_form" />
	<input type="hidden" name="plugin" value="qhmsetting" />
	<input type="hidden" name="pcmd"   value="post" />
</div>
';
//--</FTPAccess>--



	//======================================================
	//  WordPressデザイン設定フォーム
	//======================================================
	if(count($wp_dirs)){
		$body .= '<br /><br /><br /><h2 id="wordpress">WordPressテーマを利用する</h2>'."\n";
		$body .= <<<EOD
<div style="border:2px solid #ccc;padding:1em;background-color:#fafafa">
	<p>以下から、WordPressのテーマを選択して下さい。</p>
<form method="post" action="{$script}">
EOD;
	
		$body .= '<select name="qhmsetting[enable_wp_theme_name]" value="'.$params['enable_wp_theme_name'].'">';
		foreach($wp_dirs as $dir){
			$ckd = ( $dir == $params['enable_wp_theme_name'] ) ? 'selected="selected"' : '';
			$body .= '<option value="'.$dir.'" '.$ckd.'>'.$dir.'</option>';
		}
		$body .= '</select>';
	
		$body .= '
※ロゴ画像は、選べません<br /><br />
<b>追加スタイル</b><br />
<textarea name="qhmsetting[wp_add_css]" rows="5" style="width:80%">'
.$wp_add_css.
'</textarea>
<input type="hidden" name="phase" value="design" />
<input type="hidden" name="mode" value="confirm" />
<input type="hidden" name="from" value="design_form" />
<input type="hidden" name="plugin" value="qhmsetting" />
<input type="hidden" name="pcmd"   value="post" />
<input type="hidden" name="enable_wp_theme" value="1" />
<p style="text-align:center"><input type="submit" value="設定を確認する" style="font-size:16px" /></p>
</form>
<p><strong>ご確認下さい : </strong></p>
<ul style="margin-left:3%;">
<li>WordPressのテーマは、ブログのためのデザインです。ご自身で多少のカスタマイズが必要です</li>
<li>テンプレートに埋め込まれている文字や、サイドバーに読み込むリンクなど、適切に再編集して下さい</li>
<li>標準的な作り方に沿わないテーマを使うと、一部のプラグインが動作しないことがあります</li>
<li>WPテーマとの完全な互換性はありません。ご自身でのカスタマイズが必要となります</li>
</ul>
</p>
</div>
';

	}

	//======================================================
	// デザインプレビュー
	//
	//  ここでの設定は、 lib/qhm_init_main.php の中で、反映される
	//  ロジックがややこしいのは、デザインを有効にするタイミングに憂慮したため
	//======================================================
	if( isset($vars['wp_add_css']) ){
		$wp_add_css = $vars['wp_add_css'];
	}
	else if( isset($_SESSION['wp_add_css'])){
		$wp_add_css = $_SESSION['wp_add_css'];
	}	
	

	$body .= '<br /><br /><br /><h3 id="designpreview">デザインのプレビュー</h3>'."\n";
	$body .= '<div style="border:2px solid #ccc;padding:1em;background-color:#fafafa">
<p>以下から、デザインテンプレートを選択し、プレビューを押して下さい</p>';

	$body .= '<form method="post" action="'.$script.'">';
	$body .= '<p>QHM専用 : <select name="design" id="previewSelector">';
	foreach($dirs as $dir){
		$ckd = ( $dir == $params['style_name'] ) ? 'selected="selected"' : '';
		$body .= '<option value="'.$dir.'" '.$ckd.'>'.$dir.'</option>';
	}
	$body .= '</select>';
	
	$body .= '
<input type="submit" value="プレビュー" /></p>
<input type="hidden" name="phase" value="design" />
<input type="hidden" name="mode" value="form" />
<input type="hidden" name="plugin" value="qhmsetting" />
<input type="hidden" name="enable_wp_theme" value="0" />
<input type="hidden" name="pcmd"   value="post" />
</form>';


	if(count($wp_dirs))
	{
		$body .= '<br /><hr /><br />';
		$tmp_design_name = $tmp_design_name=='' ? $enable_wp_theme_name : $tmp_design_name;
		$body .= '<form method="post" action="'.$script.'">';
		$body .= '<p>WordPressテーマ : <select name="design">';
		foreach($wp_dirs as $dir){
			$ckd = ( $dir == $tmp_design_name ) ? 'selected="selected"' : '';
			$body .= '<option value="'.$dir.'" '.$ckd.'>'.$dir.'</option>';
		}
		$body .= '</select>';
		$body .= '<br /><b>追加スタイル</b><br />
					<textarea name="wp_add_css" rows="5" style="width:80%">'
					.$wp_add_css.
					'</textarea><br />';
	
		$body .= '
<input type="submit" value="プレビュー" /></p>
<input type="hidden" name="phase" value="design" />
<input type="hidden" name="mode" value="form" />
<input type="hidden" name="plugin" value="qhmsetting" />
<input type="hidden" name="enable_wp_theme" value="1" />
<input type="hidden" name="pcmd"   value="post" />
</form>
';
	}
	else{
		$body .= '<p style="color:#666">WordPressのテーマを利用するには、skin/wordpress/ に、設置します。</p>';
	}
	$body .= '</div>
<br />';

	$body .= $body_msg;


	return $body;
}

function plugin_qhmsetting_design_confirm()
{
	global $vars, $page_title, $script;

	// --------------------------------------------
	// 直接のアクセスを拒否する
	if( !isset($vars['from']) || $vars['from']!='design_form' )
	{
		return 'このページへの直接アクセスは、無効です。';
	}
	
	
	// ---------------------------------------------
	// sessionにデータを格納 & フィルタ
	// ---------------------------------------------
	
	//postからのデータを格納
	foreach( $vars['qhmsetting'] as $key=>$val)
	{
		$_SESSION['qhmsetting'][$key] 
			= $vars['qhmsetting'][$key]
			= htmlspecialchars($val);
	}

	//////////////////////////////////////////////////////////
	//
	// WordPressデザイン設定
	//
	if( $vars['enable_wp_theme']=='1') 
	{
		$style_name = $vars['qhmsetting']['enable_wp_theme_name'];
		//search thumnail image file
		$style_thumb = 'skin/wordpress/'.$style_name.'/screenshot';
		$style_img = '';
		if( file_exists($style_thumb.'.jpg') )
			$style_img = $style_thumb.'.jpg';
		else if( file_exists($style_thumb.'.png') )
			$style_img = $style_thumb.'.png';
		else if( file_exists($style_thumb.'.gif') )
			$style_img = $style_thumb.'.gif';
	
		$style_img = ($style_img != '') ? '<img src="'.$style_img.'" title="Thumbnail" />' : '';
		
		$wp_add_css = htmlspecialchars($vars['qhmsetting']['wp_add_css']);
		// ---------------------------------------------
		// Output confirmation contents
		//
		
		$body = <<<EOD
	<h2>デザイン設定の確認</h2>
	<p><b>WordPressテーマ : </b>{$style_name}<br />
	{$style_img}</p>
	<p style="font-weight:bold">追加スタイル</p>
	<p style="border:1px dashed #999;padding:10px">
	$wp_add_css
	</p> 
	
	<form method="post" action="{$script}">
	<p style="text-align:center"><input type="submit" value="設定する" style="font-size:16px" /></p>
	<input type="hidden" name="phase" value="design" />
	<input type="hidden" name="mode" value="msg" />
	<input type="hidden" name="plugin" value="qhmsetting" />
	<input type="hidden" name="from" value="design_form" />
	<input type="hidden" name="qhmsetting[enable_wp_theme_name]" value="{$style_name}" />
	<input type="hidden" name="qhmsetting[enable_wp_theme]" value="1" />
	</form>
EOD;


	}
	///////////////////////////////////////////////////////////////////
	//
	// QHM専用デザイン設定
	// 
	else{
	
		
		//imageを選んだ場合、page_titleをデフォルトで上書き
		if($vars['qhmsetting']['style_type']==='image')
		{
			$_SESSION['qhmsetting']['page_title'] = $vars['qhmsetting']['page_title'] = $page_title;
		}
		//変更しないを選んだ場合
		if($vars['qhmsetting']['style_type']==='none')
		{
			$_SESSION['qhmsetting']['page_title'] = $vars['qhmsetting']['page_title'] = $page_title;
			unset($_SESSION['qhmsetting']['style_type']);
		}
		
		// ---------------------------------------------
		// validation check
		// ---------------------------------------------
		$error = '';
		
		//画像を使う場合の処理
		if( $vars['qhmsetting']['style_type']=='image')
		{
			// ファイルエラーチェック
			switch ($_FILES["imagefile"]["error"]) {
			case UPLOAD_ERR_INI_SIZE:
			case UPLOAD_ERR_FORM_SIZE:
				$error .= "ロゴ画像のサイズが大きすぎます。<br />";
				break;
			case UPLOAD_ERR_PARTIAL;
			case UPLOAD_ERR_NO_FILE;
				$error .= "ロゴ画像をアップロードできません。";
			}
			
			// ファイルサイズをもう一度チェック
			if($_FILES["imagefile"]["size"] > 1024 * 1024){
				$error .= "ロゴ画像が、1MB以上でサイズオーバーしています。";
			}
			
			// png, jpg, gif以外のファイルを拒否
			if(!preg_match("/^image\/.*(jpeg|png|gif)$/i", $_FILES["imagefile"]["type"])) {
				$error .= "ロゴ画像は、jpeg, png, gif形式で、作成して下さい。";
			}
			
			//特定の文字以外の文字を使用したファイルを拒否
			if(preg_match("/[^\w\d\-\.]/", $_FILES["imagefile"]["name"])){
				$error .= "ロゴ画像は、英数半角のみでファイル名を付けて下さい。（".$_FILES["file"]["name"]."）";
			}
			
			$logoname = CACHE_DIR.$_FILES['imagefile']['name'];
			if( file_exists($logoname) && !is_writable($logoname)  )
			{
				$error .= "ロゴ画像を上書きできません。ロゴ画像の書き込み権限を有効にするか、アップするファイル名を変更してください。";
			}
		}
		
		if($error != ""){
			unset($_SESSION['qhmsetting']);
			return plugin_qhmsetting_design_form($error);
			
		}
	
	
		// ---------------------------------------------
		// ここからが処理
		// ---------------------------------------------
	
		$style_type = $vars['qhmsetting']['style_type'];
		if( $style_type==='none' )
		{
			$logo_type = '変更しない ';
		}
		else if( $style_type=='text')
		{
			$logo_type = 'テキスト';
			$logo_img = '『 '.$vars['qhmsetting']['page_title'].' 』';
		}
		else //画像の場合の処理
		{
			//var_dump($_FILES);
			$logo_type = '画像';
			$tmparray = explode('.', $_FILES['imagefile']['name']);	
			$type = $tmparray[ count($tmparray)-1 ];
			$prev_file = PLUGIN_QHMSETTING_LOGO_PREV_PATH.$type;
			if(move_uploaded_file($_FILES['imagefile']['tmp_name'], $prev_file))
			{
	
				chmod($prev_file, 0666);
				$logo_img = '<img src="'.$prev_file.'" style="width:450px;" /><br />'
					.'ページタイトル: '.$_SESSION['qhmsetting']['page_title'];
				
				$_SESSION['qhmsetting_logo_prev_file'] = $prev_file;
				$_SESSION['qhmsetting_logo_file'] = PLUGIN_QHMSETTING_LOGO_PATH.$type;
			}
			else{
				//error handling
				return plugin_qhmsetting_design_form('ロゴ画像をセットできませんでした。');
			}
		}
	

		//design template setting
		$style_name = $vars['qhmsetting']['style_name'];
		
		//search thumnail image file
		$style_thumb = SKIN_DIR.$style_name.'/thumbnail';
		$style_img = '';
		if( file_exists($style_thumb.'.jpg') )
			$style_img = $style_thumb.'.jpg';
		else if( file_exists($style_thumb.'.png') )
			$style_img = $style_thumb.'.png';
		else if( file_exists($style_thumb.'.gif') )
			$style_img = $style_thumb.'.gif';
	
		$style_img = ($style_img != '') ? '<img src="'.$style_img.'" title="Thumbnail" />' : '';
		
		
		// ---------------------------------------------
		// Output confirmation contents
		//
		
		$body = <<<EOD
	<h2>デザイン設定の確認</h2>
	<p><b>ロゴのタイプ : </b>{$logo_type}<br />
	{$logo_img}</p>
	<p><b>デザインテンプレート</b><br />
	{$style_name}<br />
	{$style_img}</p> 
	
	<form method="post" action="{$script}">
	<p style="text-align:center"><input type="submit" value="設定する" style="font-size:16px" /></p>
	<input type="hidden" name="phase" value="design" />
	<input type="hidden" name="mode" value="msg" />
	<input type="hidden" name="plugin" value="qhmsetting" />
	<input type="hidden" name="from" value="design_form" />
	
	<input type="hidden" name="qhmsetting[style_name]" value="{$style_name}" />
	<input type="hidden" name="qhmsetting[style_type]" value="{$style_type}" />
	<input type="hidden" name="qhmsetting[page_title]" value="{$vars['qhmsetting']['page_title']}" />
	<input type="hidden" name="qhmsetting[enable_wp_theme]" value="0" />
	</form>
EOD;
	}
	
	return $body;
}

function plugin_qhmsetting_design_msg()
{
	global $vars, $logo_image, $script;
	
	// --------------------------------------------
	// 直接のアクセスを拒否する
	if( !isset($vars['from']) || $vars['from']!='design_form' )
	{
		return 'このページへの直接アクセスは、無効です。';
	}
	
	// ---------------------------------------------
	// sessionにデータを格納 & フィルタ
	foreach( $vars['qhmsetting'] as $key=>$val)
	{
		$_SESSION['qhmsetting'][$key] 
			= $vars['qhmsetting'][$key]
			= htmlspecialchars($val);
	}
	
	//imageの場合、ロゴ画像の位置を変更し、設定に加える
	if($_SESSION['qhmsetting']['enable_wp_theme'] == '0')
	{
		if($_SESSION['qhmsetting']['style_type']=='image')
		{
			rename($_SESSION['qhmsetting_logo_prev_file'], $_SESSION['qhmsetting_logo_file']);
			$_SESSION['qhmsetting']['logo_image'] = $_SESSION['qhmsetting_logo_file'];
		}
	}
	
	//noneの場合、変更しない
	if($_SESSION['qhmsetting']['style_type']==='none')
	{
		unset($_SESSION['qhmsetting']['style_type']);
	}
	
	plugin_qhmsetting_update_ini();
	
	unset($_SESSION['temp_design']);
	
	return <<<EOD
<h2>デザインの変更完了</h2>
<p>デザインの変更を完了しました。</p>
<p>変更を反映させるには、<a href="{$script}" style="font-weight:bold;background-color:#ff6;">ここをクリック</a>して下さい</p>
EOD;
}


//--<RemoveQHMDesign>--
/**
 *   デザイン削除の確認
 */
function plugin_qhmsetting_design_remove()
{
	global $vars, $script;
	
	// --------------------------------------------
	// 直接のアクセスを拒否する
	if( !isset($vars['from']) || $vars['from']!='design_form' )
	{
		return 'このページへの直接アクセスは、無効です。';
	}

	$params = plugin_qhmsetting_getparams();

	$d_cur = trim($params['style_name']);
	$d_rem = trim($vars['qhmsetting']['style_name']);
	$dir = SKIN_DIR . $d_rem;
	$thumb = $dir . '/thumbnail.jpg';
	$thumb = file_exists($thumb)? $thumb: $dir . '/thumbnail.png';

	$body = '';
	//SKIN DIR が書き込み権限なし
	if (!is_writable(SKIN_DIR)) {
		return plugin_qhmsetting_design_form("skin/hokukenstyle/ に書き込み権限がありません");
	}
	//現行のデザインは削除できない
	else if ($d_cur == $d_rem) {
		return plugin_qhmsetting_design_form("現行のデザイン：$d_rem は削除できません");
	}
	//デザイン削除可能
	else if (file_exists($dir)) {
		if ($vars['option'] == 'confirm') {
		//確認画面を表示
		$body .= <<<EOD
	<h2>QHM専用デザイン削除の確認</h2>
	<p><b>デザイン名 : </b>{$d_rem}<br />
	<img src="{$thumb}" width="180" height="200" alt="{$d_rem}"/></p>
	
	<form method="post" action="{$script}">
	<p style="text-align:center"><input type="submit" value="削除する" style="font-size:16px" /></p>
	<input type="hidden" name="qhmsetting[style_name]" value="{$d_rem}" />
	<input type="hidden" name="phase" value="design" />
	<input type="hidden" name="mode" value="remove" />
	<input type="hidden" name="option" value="complete" />
	<input type="hidden" name="plugin" value="qhmsetting" />
	<input type="hidden" name="from" value="design_form" />
	<input type="hidden" name="qhmsetting[enable_wp_theme_name]" value="{$style_name}" />
	<input type="hidden" name="qhmsetting[enable_wp_theme]" value="1" />
	</form>
EOD;

		}
		//デザインを削除
		else if ($vars['option'] == 'complete') {
			plugin_qhmsetting_remove_dir($dir);
			
			return plugin_qhmsetting_design_form("QHM専用デザイン：$d_rem を削除しました");
		}
	}
	//デザインが存在しない
	else {
		return plugin_qhmsetting_design_form("存在しないデザイン：$d_rem が指定されました");
	
	}

	return $body;
	
}
//--</RemoveQHMDesign>--

function plugin_qhmsetting_remove_dir($dir, $remain_dir = false) {
	if ($handle = opendir("$dir")) {
		while (false !== ($item = readdir($handle))) {
			if ($item != "." && $item != "..") {
				if (is_dir("$dir/$item")) {
					remove_directory("$dir/$item");
				} else {
					unlink("$dir/$item");
				}
			}
		}
		closedir($handle);
		if (!$remain_dir) {
			if (is_link($dir)) {
				unlink($dir);
			} else {
				rmdir($dir);
			}
		}
	}
}



/**
* サイト情報
*/
function plugin_qhmsetting_info_getVals($params)
{
	return array(
		'page_title' => array(
			'title' => 'タイトル文字',
			'msg' => 'ページタイトルを設定します',
			'default' => $params['page_title']
		),
		'owneraddr' => array(
			'title' => '所在地',
			'msg' => '会社などは、会社の住所を。個人は、アバウトに住所を書く',
			'default' => $params['owneraddr']
		),
		'ownertel' => array(
			'title' => '連絡先',
			'msg' => '会社などは電話番号、個人なら適当 (contact me by emailなど)に',
			'default' => $params['ownertel']
		),
		'headcopy' => array(
			'title' => 'ヘッドコピー',
			'msg' => 'ページの一番上の１行メッセージ（SEOに重要)',
			'default' => $params['headcopy']
		),
		'keywords' => array(
			'title' => 'キーワード',
			'msg' => '検索エンジンに必要なキーワードです。　例）ホームページ,作成,北研',
			'default' => $params['keywords'],
			'option' => 'textarea',
		),
		'description' => array(
			'title' => '説明',
			'msg' => '検索エンジンに必要なホームページの説明です。',
			'default' => $params['description'],
			'option' => 'textarea',
		),
		'custom_meta' => array(
			'title' => 'その他のタグ',
			'msg' => '&lt;head&gt;タグ内に、入れたいタグを自由に書いて下さい',
			'default' => $params['custom_meta'],
			'option' => 'textarea',
		),
		'accesstag' => array(
			'title' => 'アクセス解析タグ',
			'msg' => 'アクセス解析用のタグを入力します。管理者モードでは、解析されないようになります',
			'default' => $params['accesstag'],
			'option' => 'textarea',
		),
		'modifier' => array(
			'title' => 'サイト管理者',
			'msg' => 'サイトの管理者名を入力します（会社名、組織名など）',
			'default' => $params['modifier']
		),
		'modifierlink' => array(
			'title' => '管理者ページ',
			'msg' => '管理者が別のサイトを持っていれば、そこへのリンクを書く',
			'default' => $params['modifierlink']
		),
		'nowindow' => array(
			'title' => '外部リンクの<br />開き方',
			'msg' => '外部リンクを別ウインドウで開く、開かないの設定<br />（おすすめは、「別ウインドウ」です)',
			'default' => $params['nowindow'],
			'option' => array(
				0 => "別ウインドウ",
				1 => "別ウインドウを開かない",
				2 => "特定のウインドウ",
			),
		),
		'reg_exp_host' => array(
			'title' => '別ウインドウで<br />開かない設定',
			'msg' => '別ウインドウで開かないホスト名を | で区切って入力してください',
			'default' => $params['reg_exp_host'],
		),
		'qhm_adminmenu' => array(
			'title' => '管理者認証への<br />リンク表示',
			'msg' => '管理者ページへのアクセス方法を指定します<br />（おすすめは、「右下のQHMリンクから」です)',
			'default' => $params['qhm_adminmenu'],
			'option' => array(
				0 => "常にedit thisを表示",
				1 => "右下のQHMリンクから",
				2 => "なし(QHMAdminというページ)",
			),
		),
		'no_qhm_licence' => array(
			'title' => 'ライセンス表記',
			'msg' => 'ページ右のQHMライセンス表記を表示、非表示を設定します<br />（<a href="http://www.open-qhm.net/index.php?QHMLicence#n8d1069b" target="new">非表示にすると認証ページアクセスが難しくなります</a>）',
			'default' => $params['no_qhm_licence'],
			'option' => array(
				0 => "表示する",
				1 => "非表示（非推奨・QHMAdminページからログイン）",
			),
		),
/*		'qhm_access_key' => array(
			'title' => 'ショートカット',
			'msg' => '編集時に、ショートカットキーを使うか設定ができます。<br />',
			'default' => $params['qhm_access_key'],
			'option' => array(
				0 => "利用しない",
				1 => "利用する",
			),
		),*/
		'autolink' => array(
			'title' => '自動リンク',
			'msg' => 'ページ名が長く、「\'」や「"」を利用し、QHMが正常に動かない場合、<br />「オフ」にして下さい<br />',
			'default' => $params['autolink'],
			'option' => array(
				8 => "利用する",
				0 => "利用しない",
			),
		),

	);

}

function plugin_qhmsetting_info_form($error = '')
{
	global $script;
	global $other_plugins;
	$is_qhmpro = (isset($other_plugins) && count($other_plugins) > 0);
	$hlp_info = ($is_qhmpro) ? str_replace('%PAGE%','SettingOnQHM#u51b4166',QHMPRO_HELP_LINK) : '';
	
	$error_msg = ($error!='') ? '<p style="color:red">'.$error.'</p>' : '';

	$params = plugin_qhmsetting_getparams();
	$values = plugin_qhmsetting_info_getVals($params);

	$body = '<h2>Quick Homepage Maker 設定'.$hlp_info.'</h2>';
	$body .= $error_msg;
	$body .= <<<EOD
<p>サイト情報の設定では、titleタグ、ヘッドコピー、フッターの情報、アクセス解析タグなどの設定を行います。</p>
<form method="post" action="$script">
<table class="style_table"  cellspacing="1" border="0">
<tbody>
EOD;
	
	$input = '';
	foreach($values as $key=>$value)
	{
	
		if( isset($value['option'] ) )
		{
		
			if( is_array($value['option']) )
			{
				$input = '<select name="qhmsetting['.$key.']">'."\n";
				foreach($value['option'] as $okey=>$oval )
				{
					$selected = ($value['default']==$okey) ? 'selected="selected"' : '';
					$input .= '<option value="'.$okey.'" '.$selected.'>'.$oval.'</option>'."\n";
				}
				$input .= '</select>';
			}
			else if( $value['option']=='textarea' )
			{
				$input = '<textarea name="qhmsetting['.$key.']" rows="5" cols="55" style="width:97%">'.h( $value['default'] ).'</textarea>';
			}
		}
		else
		{
			$input = '<input type="text" size="50" name="qhmsetting['.$key.']" value="'.h( $value['default'] ).'" style="width:97%" />';
		}
		
		$body .= '<tr>
    <th class="style_th" style="font-size:12px;width:9em;">'.$value['title'].'</th>
	<td class="style_td" style="font-size:12px">'.$input.'<br /><span style="color:gray">'.$value['msg'].'</span></td>
</tr>
';
	}
	
	$body .= '
</tbody>
</table>
<input type="hidden" name="mode" value="download" />
<p style="text-align:center"><input type="submit" name="ok" value="設定を確認する" /></p>
<input type="hidden" name="phase" value="info" />
<input type="hidden" name="mode" value="confirm" />
<input type="hidden" name="plugin" value="qhmsetting" />
<input type="hidden" name="from" value="info_form" />
</form>	
';

	return $body;
}

function plugin_qhmsetting_info_confirm()
{
	global $vars, $script;
	
	// --------------------------------------------
	// 直接のアクセスを拒否する
	if( !isset($vars['from']) || $vars['from']!='info_form' )
	{
		return 'このページへの直接アクセスは、無効です。';
	}
	
	
	// -----------------------------------
	// validation check
	// -----------------------------------
	$error = '';
	
	if($error != '')
		return plugin_qhmsetting_admin_form($error);


	// -----------------------------------
	// processing here
	// -----------------------------------
	$params = plugin_qhmsetting_getparams();
	$values = plugin_qhmsetting_info_getVals($params);

	$body = '<h2>Quick Homepage Maker 設定</h2>';
	$body .= '
<p>以下の内容でよければ、ページ下部の「設定する」をクリックしてください</p>
<table class="style_table"  cellspacing="1" border="0">
<tbody>
';

	$qsv = $vars['qhmsetting'];
	foreach($values as $key=>$value)
	{
		if( isset($value['option']) && is_array($value['option']) )
		{
			$data = $value['option'][ $qsv[$key] ];
		}
		else
		{
			$data = $qsv[$key];
		}
	
		$body .= '<tr>
    <th class="style_th" style="font-size:12px">'.$value['title'].'</th>
	<td class="style_td" style="font-size:12px">'. h($data) .'</td>
</tr>
';
	}

	$body .= '
</tbody>
</table>
';
	
	$body .= '<form method="post" action="'.$script.'">';
	foreach($qsv as $key=>$val){
		$body .= '<input type="hidden" name="qhmsetting['.$key.']" value="'. h($val).'" />'."\n";
	}
	$body .= '
<p style="text-align:center"><input type="button" name="back" value="戻る" onclick="history.back();" /> <input type="submit" name="ok" value="設定する" /></p>
<input type="hidden" name="phase" value="info" />
<input type="hidden" name="mode" value="msg" />
<input type="hidden" name="plugin" value="qhmsetting" />
<input type="hidden" name="from" value="info_form" />
</form>';
	
//	var_dump($vars['qhmsetting']);
//	exit;

	return $body;
}

function plugin_qhmsetting_info_msg()
{
	global $vars, $script;
	
	// --------------------------------------------
	// 直接のアクセスを拒否する
	if( !isset($vars['from']) || $vars['from']!='info_form' )
	{
		return 'このページへの直接アクセスは、無効です。';
	}


	// --------------------------------------------
	foreach($vars['qhmsetting'] as $key=>$val)
	{
		$_SESSION['qhmsetting'][$key] = $val;
	}

	plugin_qhmsetting_update_ini();
	
	
	return <<<EOD
<h2>サイト情報の変更完了</h2>
<p>サイト情報を変更しました。</p>
<p>変更を反映させるには、<a href="{$script}" style="font-weight:bold;background-color:#ff6;">ここをクリック</a>して下さい</p>
EOD;

}

/**
* 編集用ID、パスワードの設定
*/
function plugin_qhmsetting_admin_form($error = '')
{
	global $script, $vars;
	global $other_plugins;
	$is_qhmpro = (isset($other_plugins) && count($other_plugins) > 0);
	$hlp_admin = ($is_qhmpro) ? str_replace('%PAGE%','SetPassword',QHMPRO_HELP_LINK) : '';
	
	$params = plugin_qhmsetting_getparams();
	
	
	$error_msg .= ($error!='') ? '<p style="color:red">'.$error.'</p>' : '';
	
	//ユーザー名だけ特別扱い
	if( isset($vars['qhmsetting']['username']) ){
		$uname = $vars['qhmsetting']['username'];
	}
	else{
		$uname = $params['username'];
	}

	$body = <<<EOD
<h2>編集用ユーザー名の変更{$hlp_admin}</h2>
<p>ここで設定したユーザー名とパスワードは、忘れないようにして下さい。<br />
※英数半角と一部の記号のみ</p>
{$error_msg}
<form method="post" action="{$script}">
<table class="style_table" cellspacing="1" border="0">
	<tr>
		<th class="style_th">　ユーザー名　</th>
		<td class="style_td">　<input type="text" name="qhmsetting[username]" size="18" value="{$uname}"  />　</td>
	</tr>
	<tr>
		<th class="style_th">　現在のパスワード　</th>
		<td class="style_td">　<input type="password" name="qhmsetting[password]" size="18" /></td>
	</tr>
	<tr>
		<th class="style_th">　新パスワード　</th>
		<td class="style_td">　<input type="password" name="qhmsetting[password1]" size="18" />　<br />
		　<input type="password" name="qhmsetting[password2]" size="18"  />　<br />
		確認のため、２度入力してください</td>
	</tr>
</table>

<p style="text-align:center"><input type="submit" value="設定を確認する" style="font-size:16px" /></p>
<input type="hidden" name="phase" value="admin" />
<input type="hidden" name="mode" value="confirm" />
<input type="hidden" name="plugin" value="qhmsetting" />
<input type="hidden" name="from" value="admin_form" />
</form>

EOD;

	return $body;
}

function plugin_qhmsetting_admin_confirm()
{
	global $vars, $script;
	global $auth_users, $username, $passwd;
	
	// --------------------------------------------
	// 直接のアクセスを拒否する
	if( !isset($vars['from']) || $vars['from']!='admin_form' )
	{
		return 'このページへの直接アクセスは、無効です。';
	}
	
	
	// -----------------------------------
	// validation check
	// -----------------------------------
	$error = '';

	//ユーザーの重複を探すために
	unset( $auth_users[ $username ] );
	
	if( isset( $auth_users[ $vars['qhmsetting']['username'] ] ) )
		$error .= '他のユーザーと名前が重複しています<br />';
	if( $passwd != pkwk_hash_compute( $vars['qhmsetting']['password'] ) )
		$error .= '現在のパスワードと、一致しません<br />';
	if( !ctype_alnum($vars['qhmsetting']['username']) )
		$error .= 'ユーザー名は、半角英数のみで入力してください<br />';
	if( $vars['qhmsetting']['password1'] != $vars['qhmsetting']['password2'] )
		$error .= '新パスワードが一致しません<br />';
	if( !preg_match(ALLOW_PASSWD_PATTERN , $vars['qhmsetting']['password1']) )
		$error .= 'パスワードは、英数半角と一部の記号のみ(スペース不可)で入力してください<br />';
	if( strlen($vars['qhmsetting']['password1']) < 6 )
		$error .= 'パスワードは、6文字以上を設定してください<br />';
	
	if($error != '')
		return plugin_qhmsetting_admin_form($error);
	



	// -----------------------------------
	// process from here
	// -----------------------------------
	$password = md5($vars['qhmsetting']['password1']);
	
	$body = <<<EOD
<h2>ユーザー設定の確認</h2>
<p>以下の内容でよろしいでしょうか？</p>
<ul>
	<li><b>ユーザー名　：　</b><span style="font-size:24px">{$vars['qhmsetting']['username']}</span></li>
	<li><b>パスワード　：　</b>***********</li>
</ul>
<form method="post" action="{$script}">
<p style="text-align:center"><input type="submit" value="設定する" style="font-size:16px" /> <input type="button" value="戻る" onclick="history.back();" /></p>
<input type="hidden" name="phase" value="admin" />
<input type="hidden" name="mode" value="msg" />
<input type="hidden" name="plugin" value="qhmsetting" />
<input type="hidden" name="from" value="admin_form" />
<input type="hidden" name="qhmsetting[username]" value="{$vars['qhmsetting']['username']}" />
<input type="hidden" name="qhmsetting[password]" value="$password" />
</form>
EOD;
	
	return $body;
}

function plugin_qhmsetting_admin_msg()
{
	global $vars, $script;
	
	// --------------------------------------------
	// 直接のアクセスを拒否する
	if( !isset($vars['from']) || $vars['from']!='admin_form' )
	{
		return 'このページへの直接アクセスは、無効です。';
	}
	
	$uname = $_SESSION['qhmsetting']['username'] = $vars['qhmsetting']['username'];
	$_SESSION['qhmsetting']['passwd'] = '{x-php-md5}'.$vars['qhmsetting']['password'];

	plugin_qhmsetting_update_ini();
	
	session_destroy();
	
	return <<<EOD
<h2>ユーザーの変更完了</h2>
<p>編集ユーザーの変更を完了しました。</p>
<p>新しいユーザー名は、<span style="font-size:24px;">{$uname}</span>、パスワードは「******」です。</p>
<p>再度、ログインが必要となります。<a href="{$script}?plugin=qhmauth" style="font-weight:bold;background-color:#ff6;">ここをクリック</a>して下さい</p>
EOD;

}


//--<MailForm>--
/**
* メール送信設定
*/
function plugin_qhmsetting_mail_form($error='')
{
	global $script;
	global $other_plugins;
	$is_qhmpro = (isset($other_plugins) && count($other_plugins) > 0);
	$hlp_mail = ($is_qhmpro) ? str_replace('%PAGE%','MailSetting',QHMPRO_HELP_LINK) : '';

	$params = plugin_qhmsetting_getparams();
	$error_msg = ($error!='') ? '<p style="color:red">'.$error.'</p>' : '';

	//notify
	if($params['notify']){
		$notify_checked1 = "checked";
		$notify_checked2 = "";
	}
	else{
		$notify_checked1 = "";
		$notify_checked2 = "checked";
	}
	//notify_diff_only
	if($params['notify_diff_only']){
		$notify_diff_only_checked1 = "checked";
		$notify_diff_only_checked2 = "";
	}
	else{
		$notify_diff_only_checked1 = "";
		$notify_diff_only_checked2 = "checked";
	}
	//smtp_auth
	if($params['smtp_auth']){
		$smtp_auth_checked1 = "checked";
		$smtp_auth_checked2 = "";
	}
	else{
		$smtp_auth_checked1 = "";
		$smtp_auth_checked2 = "checked";	
	}
	//smtp_auth
	if($params['google_apps']){
		$google_apps_checked1 = "checked";
		$google_apps_checked2 = "";
	}
	else{
		$google_apps_checked1 = "";
		$google_apps_checked2 = "checked";
	}

	$body = <<<EOD
<h2>メール送信設定{$hlp_mail}</h2>
<h3>更新通知設定</h3>
<p>ページが更新される度に、メールで知らせる機能です。</p>
{$error_msg}
<form method="post" action="{$script}">
<table class="style_table" cellspacing="1" border="0">
	<tr>
		<th class="style_th">更新通知</th>
		<td class="style_td"><input type="radio" name="qhmsetting[notify]" value="1" $notify_checked1 />通知する、　<input type="radio" name="qhmsetting[notify]" value="0" $notify_checked2 />通知しない</td>
	</tr>
	<tr>
		<th class="style_th">差分のみ送信</th>
		<td class="style_td"><input type="radio" name="qhmsetting[notify_diff_only]" value="1" $notify_diff_only_checked1 />差分のみ、　<input type="radio" name="qhmsetting[notify_diff_only]" value="0" $notify_diff_only_checked2 />全文</td>
	</tr>
	<tr>
		<th class="style_th">送信者メールアドレス</th>
		<td class="style_td"><input type="text" name="qhmsetting[notify_from]" value="{$params['notify_from']}" size="30" /></td>
	</tr>
	<tr>
		<th class="style_th">更新通知先</th>
		<td class="style_td"><input type="text" name="qhmsetting[notify_to]" value="{$params['notify_to']}" size="30" /></td>
	</tr>
</table>

<ul class="list1">
	<li><b>個人で使っている場合</b><br />
	毎回メールで通知されると面倒なので、「通知しない」がお勧めです
	</li>
	<li><b>社内情報共有の場合</b><br />
	通知機能をオンにして、通知先をメーリングリストに設定すると便利です
	</li>
</ul>

<h3>メール送信設定</h3>

<p>更新通知を送信する際のメールサーバーの設定を行います。<br />
以下に必要項目を入力して下さい。<br />
なお、ほぼすべてのユーザーが、以下の設定を変更する必要はありません。</p>

<table class="style_table" cellspacing="1" border="0">
	<tr>
		<th class="style_th">SMTPサーバー</th>
		<td class="style_td"><input type="text" name="qhmsetting[smtp_server]" value="{$params['smtp_server']}" size="26" /></td>
	</tr>
	<tr>
		<th class="style_th">SMTP AUTH</th>
		<td class="style_td"><input type="radio" name="qhmsetting[smtp_auth]" value="1" {$smtp_auth_checked1} />利用する、　<input type="radio" name="qhmsetting[smtp_auth]" value="0" {$smtp_auth_checked2} />利用しない</td>
	</tr>
	<tr>
		<th class="style_th">POPサーバー</th>
		<td class="style_td"><input type="text" name="qhmsetting[pop_server]" size="32"  value="{$params['pop_server']}" /></td>
	</tr>
	<tr>
		<th class="style_th">POPアカウント</th>
		<td class="style_td"><input type="text" name="qhmsetting[pop_userid]" value="{$params['pop_userid']}" size="26" /></td>
	</tr>	
	<tr>
		<th class="style_th">POPパスワード</th>
		<td class="style_td"><input type="password" name="qhmsetting[pop_passwd]" value="{$params['pop_passwd']}" size="26" /></td>
	</tr>	
</table>
<br />

<h3>Google Apps利用者</h3>
<p>GoogleAppsを導入している方で、自動返信メールの投稿内容、ダウンロード通知など、<a href="http://www.google.com/support/a/bin/answer.py?answer=55299&topic=14868" target="new">「自分のアカウントにメールを送ると届かない」（参照：GoogleAppsヘルプ）</a>場合、以下を設定して下さい。</p>

<table class="style_table">
	<tr>
		<th class="style_th">GoogleApps宛にメールを送る</th>
		<td class="style_td"><input type="radio" name="qhmsetting[google_apps]" value="1" {$google_apps_checked1} />利用する、　<input type="radio" name="qhmsetting[google_apps]" value="0" {$google_apps_checked2} />利用しない</td>
	</tr>
	<tr>
		<th class="style_th">メールのドメイン</th>
		<td class="style_td"><input type="text" name="qhmsetting[google_apps_domain]" size="30" value="{$params['google_apps_domain']}"/></td>
	</tr>
</table>

<p style="text-align:center"><input type="submit" value="設定を確認する" style="font-size:16px" /></p>
<input type="hidden" name="phase" value="mail" />
<input type="hidden" name="mode" value="confirm" />
<input type="hidden" name="plugin" value="qhmsetting" />
<input type="hidden" name="from" value="mail_form" />

</form>

EOD;

	return $body;
}

function plugin_qhmsetting_mail_confirm()
{
	global $vars, $script;
	
	// --------------------------------------------
	// 直接のアクセスを拒否する
	if( !isset($vars['from']) || $vars['from']!='mail_form' )
	{
		return 'このページへの直接アクセスは、無効です。';
	}
	
	
	// -----------------------------------
	// validation check
	// -----------------------------------
	
	foreach($vars['qhmsetting'] as $key => $val)
	{
		$_SESSION['qhmsetting'][$key] = $val;
	}
//	var_dump($_SESSION['qhmsetting']);
	
	$error = '';
	
	//本当は、もっとややこしくないと正しくないらしい
	$email_match = '/^([a-z0-9_]|\-|\.|\+)+@(([a-z0-9_]|\-)+\.)+[a-z]{2,6}$/i';
	$hankaku = '/^[a-z0-9_\-\.\+@]+$/i';

	if($vars['qhmsetting']['notify']==1)
	{
		if(! preg_match($email_match, $vars['qhmsetting']['notify_from']) )
			$error .= '送信者のメールアドレスを正しく、入力してください<br />';
		if(! preg_match($email_match, $vars['qhmsetting']['notify_to']) )
			$error .= '更新通知先を正しく、設定して下さい。<br />';
			
		
		if(! preg_match($hankaku, $vars['qhmsetting']['smtp_server']) )
			$error .= 'SMTPサーバーを設定して下さい';
			
		if( $vars['qhmsetting']['smtp_auth'] )
		{
			if(! preg_match($hankaku, $vars['qhmsetting']['pop_server'] ) )
				$error .= 'POPサーバーを正しく、設定して下さい。<br />';
			if(! preg_match($hankaku, $vars['qhmsetting']['pop_userid'] ) )
				$error .= 'POPアカウントを入力してください。<br />';
			if(! preg_match($hankaku, $vars['qhmsetting']['pop_passwd'] ) )
				$error .= 'POPパスワードを入力してください。<br />';		
		}
	}
	
	if( $vars['qhmsetting']['google_apps'] && (! preg_match($hankaku, $vars['qhmsetting']['google_apps_domain']) ) )
	{
		$error .= 'ドメインを正しく設定して下さい。';
	}
		
	if($error != '')
		return plugin_qhmsetting_mail_form($error);
	



	// -----------------------------------
	// process from here
	// -----------------------------------

	$notify_msg = '';
	if($vars['qhmsetting']['notify'])
	{
		$notify_msg = "利用する<br />(送り先:{$vars['qhmsetting']['notify_to']}、";
		if($notify_diff_only)
			$notify_msg .= ' 内容:差分のみ)';
		else
			$notify_msg .= ' 内容:全文)';
	}
	else
	{
		$notify_msg = '利用しない';
	}
	
	$notify_name_msg = $vars['qhmsetting']['notify_from'];
	
	$smtp_auth_msg = '利用しない';
	if($vars['qhmsetting']['smtp_auth'])
	{
		$smtp_auth_msg = 'サーバー: '.$vars['qhmsetting']['pop_server'].'<br />';
		$smtp_auth_msg .= 'POPユーザー: '.$vars['qhmsetting']['pop_userid'].'<br />'; 
		$smtp_auth_msg .= 'POPパスワード: ********<br />'; 
	}
	
	$google_apps_msg = '設定しない';
	if($vars['qhmsetting']['google_apps'])
	{
		$google_apps_msg = '利用する<br />'.$vars['qhmsetting']['google_apps_domain'];
	}
	
	$hiddens = '';
	foreach($vars['qhmsetting'] as $key=>$val )
	{
		$hiddens .= '<input type="hidden" name="'.$key.'" value="'.$val.'" />'."\n";
	}
	

	$body = <<<EOD
<h2>メール設定の確認</h2>
<table class="style_table" cellspacing="1" border="0">
	<tr>
		<th class="style_th">更新通知</th>
		<td class="style_td">{$notify_msg}</td>
	</tr>
	<tr>
		<th class="style_th">メール送信者設定</th>
		<td class="style_td">{$notify_name_msg}</td>
	</tr>
	<tr>
		<th class="style_th">メール送信サーバー</th>
		<td class="style_td">{$vars['qhmsetting']['smtp_server']}</td>
	</tr>
	<tr>
		<th class="style_th">SMTP Auth<br />pop before smtp</th>
		<td class="style_td">{$smtp_auth_msg}</td>
	</tr>
	<tr>
		<th class="style_th">GoogleApps設定</th>
		<td class="style_td">{$google_apps_msg}</td>
	</tr>
</table>

<form method="post" action="{$script}">
<p style="text-align:center"><input type="submit" value="設定する" style="font-size:16px" /></p>
<input type="hidden" name="phase" value="mail" />
<input type="hidden" name="mode" value="msg" />
<input type="hidden" name="plugin" value="qhmsetting" />
<input type="hidden" name="from" value="mail_form" />
{$hiddens}

</form>

EOD;
	
	return $body;
}

function plugin_qhmsetting_mail_msg()
{

	global $vars;
	
	// --------------------------------------------
	// 直接のアクセスを拒否する
	if( !isset($vars['from']) || $vars['from']!='mail_form' )
	{
		return 'このページへの直接アクセスは、無効です。';
	}
	
	
	//set session 
	foreach( $vars['qhmsetting'] as $key=>$val)
	{
		$_SESSION['qhmsetting'][$key] 
			= $vars['qhmsetting'][$key]
			= htmlspecialchars($val);
	}
	
	plugin_qhmsetting_update_ini();
	
	return <<<EOD
<h2>メール送信設定の完了</h2>
<p>メール送信設定を完了しました。</p>
<p>自動返信メールフォームなどを利用して、テストを行って下さい。<br /><a href="{$script}" style="font-weight:bold;background-color:#ff6;">トップに戻る</a></p>
EOD;
}
//--</MailForm>--



//--<UserForm>--
/**
* ユーザー権限設定
*/
function plugin_qhmsetting_user_form($error = '')
{
	global $custom_meta, $script;
	global $other_plugins;
	$is_qhmpro = (isset($other_plugins) && count($other_plugins) > 0);
	$hlp_useradmin = ($is_qhmpro) ? str_replace('%PAGE%','UserAuthSetting',QHMPRO_HELP_LINK) : '';

	$custom_meta .= '<script type="text/javascript" src="./js/jquery.js"></script>
<script type="text/javascript" src="./js/jquery.tablesorter.min.js"></script>
<script type="text/javascript" src="./js/opadmin.js"></script>
<script type="text/javascript">
$(document).ready(function() 
    { 
        $("#patternlist").tablesorter(); 
    } 
);
</script>
<style type="text/css">
/* tables */
table.tablesorter {
	font-family:arial;
	background-color: #CDCDCD;
	margin:10px 0pt 15px;
	font-size: 8pt;
	width: 100%;
	text-align: left;
}
table.tablesorter thead tr th, table.tablesorter tfoot tr th {
	background-color: #e6EEEE;
	border: 1px solid #FFF;
	font-size: 8pt;
	padding: 4px;
}
table.tablesorter thead tr .header {
	background-image: url(image/hokuken/bg.gif);
	background-repeat: no-repeat;
	background-position: center right;
	cursor: pointer;
}
table.tablesorter tbody td {
	color: #3D3D3D;
	padding: 4px;
	background-color: #FFF;
	vertical-align: top;
}
table.tablesorter tbody tr.odd td {
	background-color:#F0F0F6;
}
table.tablesorter thead tr .headerSortUp {
	background-image: url(image/hokuken/asc.gif);
}
table.tablesorter thead tr .headerSortDown {
	background-image: url(image/hokuken/desc.gif);
}
table.tablesorter thead tr .headerSortDown, table.tablesorter thead tr .headerSortUp {
background-color: #8dbdd8;
}
</style>
';
	$back_url = '';
	
	$users_data = _get_users_data();
	
	
	//user accessの取得
	$fp = fopen('qhm_access.ini.txt', "r");
	if ($fp) {
		flock( $fp, LOCK_SH );
		
		while (!feof($fp)) {
			$line = fgets($fp);
			if (trim($line) != "") {
				list($type,$pattern,$name) = explode(',', $line);
				$access_data[] = array("type"=>trim($type), "pattern"=>$pattern, "user"=>trim($name));
			}
		}
		fclose($fp);
	}

	$body = <<<EOD
$back_url
<h2>アクセス権限設定{$hlp_useradmin}</h2>
<p style="color:red">{$error}</p>
<form method="post" action="{$script}" id="frm_users" name="frm_users">
<fieldset style="border:1px solid #999;padding:5px 5px">
<legend style="color:#666;padding:0px 5px">ユーザーの設定</legend>
<table cellspacing="5" cellpadding="0" border="0"><tbody>
<tr>
<td class="style_td" style="width:300px;padding:5px 5px 0px 5px;" valign="top">
<table class="style_table" align="center" style="width:100%;font-size:12px;" cellspacing="1" cellpadding="0" border="0"><tbody>
  <tr>
  <th class="style_th">ユーザ名</th><td class="style_td" width="100"><input type="text" name="qhmsetting[username]" id="username" value="" style="width:90px" /></td>
  </tr>
  <tr>
  <th class="style_th">パスワード</th><td class="style_td" width="100"><input type="password" name="qhmsetting[passwd]" id="passwd" value="" style="width:90px" /></td>
  </tr>
  <tr>
  <th class="style_th">パスワード<br>再入力</th><td class="style_td" width="100"><input type="password" name="qhmsetting[repasswd]" id="repasswd" value="" style="width:90px" /></td>
  </tr>
</tbody></table>
</td>
<td width="70" valign="top" style="padding-top:40px;"><input type="submit" name="user_add" value="追　加 ->" style="width:90px;" />
<!-- plugin用のhidden parameter -->
<input type="hidden" name="phase" value="user" />
<input type="hidden" name="mode" value="msg" />
<input type="hidden" name="plugin" value="qhmsetting" />
</td>
<td style="width:370px;padding:5px;background-color:#fff;" valign="top">
<table class="style_th" align="center" style="width:100%;font-size:12px;color:#333;"><tbody>
<tr><td height="20" class="style_td_title" style="padding:1px 3px;">ユーザーリスト</td></tr>
EOD;

	if (is_array($users_data)) {

		ksort($users_data);

		foreach ($users_data as $key=>$row) {
			$body .= <<<EOD
	<tr><td class="style_td" style="padding:1px 3px;" onclick="this.style.backgroundColor='skyblue';selectUser('target_user','{$key}');" onmouseover="hightlight(this,'pink');" onmouseout="hightlight(this,'#EFEFF1');"><div>{$key} <input type="button" onclick="rewritePasswd('{$key}');" value="パスワード変更"  /> <input type="button" onclick="deleteUser('{$key}');" value="削除" /></div></td></tr>
EOD;
		}
	}
	
	$body .= <<<EOD
</tbody></table>
</td>
</tr>
<tr>
  <td height="20" colspan="4" style="padding:5px;color:red;font-size:12px;" align="right">※ パスワードの変更、ユーザの削除は、リストからユーザーを選択してください
  <input type="hidden" name="target_user" id="target_user" value="" />
  <input type="hidden" name="op_passwd" value="" />
  <input type="hidden" name="user_op" value="" />

  </td></tr>
</tbody></table>
</fieldset>
<fieldset style="border:1px solid #999;padding:5px 5px;margin:15px 0px 0px 0px">
<legend style="color:#666;padding:0px 5px;">アクセス権限の設定</legend>

<p>アクセス権限の追加</p>
<table class="style_table" width="100%" style="margin:5px;" cellspacing="1" cellpadding="0" border="0"><tbody>
<tr height="20">
  <th class="style_th" height="20" style="text-align:center;margin:5px auto;font-size:8pt;">ページ名のパターン</th>
  <th class="style_th" height="20" style="text-align:center;margin:5px auto;font-size:8pt;">ユーザー名</th>
  <th class="style_th" height="20" style="text-align:center;margin:5px auto;font-size:8pt;">アクセス権限</th>
  <th class="style_th" valign="center" width="80" style="text-align:center;margin:5px auto;font-size:8pt;" rowspan="2"><input type="submit" name="add_access" value="追　加" style="width:60px" /></th>
</tr>
<tr height="40">
  <td class="style_td" height="40" width="350"><select name="pattern_pos"><option value="all">完全</option><option value="front">前方</option><option value="back">後方</option><option value="part">部分</option><option value="other">その他</option></select> <input type="text" name="pattern" id="pattern" value="" style="width:200px" /></td>
  <td class="style_td" height="40" width="100">
  <select name="access_user">

EOD;
	
	foreach ($users_data as $key => $val) {
		$body .=  '<option value="'.$key.'">'.$key.'</option>';
	}
	
	$body .= <<<EOD
  </select></td>
  <td class="style_td" height="40" width="150"><input type="radio" name="type" value="r" checked="checked" /> 閲覧制限<br /><input type="radio" name="type" value="e" /> 編集許可</td>
</tr>
</tbody>
</table>
<p>アクセス権限のリスト</p>
<!-- <p><span style="color:gray;font-size:12px">※ 項目をクリックすると、ソートできます。Shiftを押しながらクリックすると、マルチソートできます</span></p> -->
<table id="patternlist" class="tablesorter" width="100%" style="margin:5px 5px 5px 5px;" cellspacing="1" cellpadding="0" border="0">
<thead>
<tr>
  <th class="style_th" height="20" style="text-align:center;margin:5px auto">ページ名のパターン</th>
  <th class="style_th" height="20" style="text-align:center;margin:5px auto">ユーザ名</th>
  <th class="style_th" height="20" width="90" style="text-align:center;margin:5px auto">アクセス権限</th>
  <th class="style_th" height="20" style="text-align:center;margin:5px auto">操　作</th>
</tr>
</thead>
<tbody>
EOD;

	if (is_array($access_data)) {
		$row_cnt = 0;
		foreach ($access_data as $key=>$row) {
			$type_name = _get_type_name($row["type"]);
			$body .= <<<EOD
<tr>
  <td class="style_td" height="20">{$row["pattern"]}</td>
  <td class="style_td" height="20" width="140">{$row["user"]}</td>
  <td class="style_td" height="20" width="90">{$type_name}</td>
  <td class="style_td" height="20" width="80" style="text-align:center;margin:5px auto"><input type="button" onclick="deletePattern('{$row["user"]}','{$row_cnt}');" style="width:60px" value="削　除" /></td>
</tr>
EOD;
			$row_cnt++;	
		}
	}

	$body .= <<<EOD
</tbody>
</table>
</fieldset>
<input type="hidden" name="pattern_op" value="" /><input type="hidden" name="delno" id="delno" value="" />
</form>

EOD;
	
	return $body;

}

function plugin_qhmsetting_user_msg()
{
	global $vars, $script;
	$msg = '';
	
	// writable check
	if( !is_writable(QHM_USER_INI_FILE) )
	{
		return '<h2>エラー</h2><p>qhm_users.ini.txt の書き込み権限がありません。</p>';
	}
	// writable check
	if( !is_writable(QHM_ACCESS_INI_FILE) )
	{
		return '<h2>エラー</h2><p>qhm_access.ini.txt の書き込み権限がありません。</p>';
	}
	
	
	// ------------------------------------
	// add user
	if( isset($vars['user_add']) )
	{
		$error = _check_userdata($vars['qhmsetting']);
		if( $error != '' )
			return plugin_qhmsetting_user_form($error);
			
		$data = $vars['qhmsetting']['username']
				.',{x-php-md5}'.md5($vars['qhmsetting']['passwd'])."\n";
		
		_write_userfile($data, "a");
		
		
		$msg = "ユーザーを追加しました。";
	}
	
	
	// -------------------------------------
	// del user
	if( $vars['user_op'] == 'delete_user')
	{
		$users_data = _get_users_data();
		$user = $vars['target_user'];

		if( isset($users_data[$user]) )
		{
		
			$acclist = _get_accessdata();
			
			$dat = '';
			foreach($acclist as $k=>$acc){
				if($acc['user']===$user){
					//do nothing
				}
				else{
					$dat .= $acc['type'].','.$acc['pattern'].','.$acc['user']."\n";
				}
			}
			_write_accessfile($dat, 'w');

		
			unset($users_data[$user]);
			$data = '';
			foreach($users_data as $key=>$value)
			{
				$data .= $key.','.$value['passwd']."\n";
			}
			
			_write_userfile($data, "w");
			
			
		}
		
		$msg = "ユーザーを削除しました。";
	}
	
	
	// --------------------------------------
	// reset passwd
	if( $vars['user_op'] == 'rewrite_password' )
	{
		$msg = "ユーザーパスワードを設定しました";
		$passwd = $vars['op_passwd'];
		
		//error
		$error = '';
		
		if( $passwd == ''){
			$error = 'パスワードなしは、設定できません。';
		}
		else if( !preg_match("/^[a-zA-Z0-9]+$/",$passwd) ){
			$error = 'パスワードは、半角英数を入力してください';
		}
		
		if($error!=''){
			return plugin_qhmsetting_user_form($error);
		}
		

		$usr = $vars['target_user'];
		$pw = '{x-php-md5}'.md5($vars['op_passwd']);

		$users_data = _get_users_data();

		if( isset( $users_data[$usr] ) )
		{
			$users_data[$usr]['passwd'] = $pw;
		}
		
		$data = '';
		foreach($users_data as $key=>$value)
		{
			$data .= $key.','.$value['passwd']."\n";
		}
		
		_write_userfile($data, "w");
	}
	
	// -------------------------------------------
	// 権限変更
	//
	if( isset( $vars['add_access']  ) )
	{
	
		$type =  input_filter($vars['type']);
		$pattern = _get_pregdata($vars["pattern"], $vars["pattern_pos"]);
		$user = input_filter($vars['access_user']);

		$data = $type.",".$pattern.",".$user."\n";
		_write_accessfile($data, "a");

		$msg = '権限を追加しました。';
	
	}
	
	
	if( $vars['pattern_op'] == 'delete_pattern' )
	{
		//データ作成
		$acclist = _get_accessdata();
		unset($acclist[ $vars['delno']  ]);
		
		$data = '';
		foreach($acclist as $key=>$value)
		{
			$data .= $value['type'].','.$value['pattern'].','.$value['user']."\n";
		}
		
		_write_accessfile($data,"w");
	
		$msg = 'アクセス権限を削除しました。';
	}
	
	//----------------------------------------------
	// 終了処理
	
	return plugin_qhmsetting_user_form($msg);
}
//--</UserForm>--


function plugin_qhmsetting_user2_form($error = '')
{
	global $custom_meta, $script;
	$custom_meta .= '<script type="text/javascript" src="./js/opadmin.js"></script>';
	
	if(! isset($_SESSION['usr']) ){
		return '<p><a href="'.$script.'?cmd=qhmauth">ログイン</a>してください。</p>';
	}
	
	$body = <<<EOD
<h2>パスワード変更</h2>
<p style="color:red">{$error}</p>
<form method="post" action="{$script}" id="frm_users" name="frm_users">

<table class="style_table" cellspacing="1" border="0">
	<tr>
		<th class="style_th">　ユーザー名　</th>
		<td class="style_td">　{$_SESSION['usr']}　</td>
	</tr>
	<tr>
		<th class="style_th">　現在のパスワード　</th>
		<td class="style_td">　<input type="password" name="op_passwd" size="18" /></td>
	</tr>
	<tr>
		<th class="style_th">　新パスワード　</th>
		<td class="style_td">　<input type="password" name="op_passwd1" size="18" />　<br />
		　<input type="password" name="op_passwd2" size="18"  />　<br />
		確認のため、２度入力してください</td>
	</tr>
</table>
<p style="text-align:center"><input type="submit" name="resetpasswd" value="変更" /> <input type="button" name="back" value="戻る" onclick="location.href='{$script}'" /></p>
<input type="hidden" name="plugin" value="qhmsetting" />
<input type="hidden" name="phase" value="user2" />
<input type="hidden" name="mode" value="msg" />
</form>
<br />
EOD;
	
	return $body;
}

function plugin_qhmsetting_user2_msg()
{
	global $vars, $script, $auth_users;
	$msg = '';
	
	// writable check
	if( !is_writable(QHM_USER_INI_FILE) )
	{
		return '<h2>エラー</h2><p>qhm_users.ini.txt の書き込み権限がありません。</p>';
	}
	// writable check
	if( !is_writable(QHM_ACCESS_INI_FILE) )
	{
		return '<h2>エラー</h2><p>qhm_access.ini.txt の書き込み権限がありません。</p>';
	}
		
	// --------------------------------------
	// reset passwd
	$msg = "ユーザーパスワードを設定しました";
	$passwd  = $vars['op_passwd'];
	$passwd1 = $vars['op_passwd1'];
	$passwd2 = $vars['op_passwd2'];
	
	//error
	$error = '';
	if( $auth_users[ $_SESSION['usr'] ] != '{x-php-md5}'.md5($passwd) ){
		$error = '現在のパスワードが一致しません。<br />';
	}
	if( $passwd1 == ''){
		$error .= 'パスワードなしは、設定できません。<br />';
	}
	else if( $passwd1 !== $passwd2){
		$error .= 'パスワードが違います<br />';
	}
	else if( !preg_match(ALLOW_PASSWD_PATTERN, $passwd1) ){
		$error .= 'パスワードは、英数半角と一部の記号のみ(スペース不可)で入力してください<br />';
	}
	else if( strlen($passwd1) < 6 ){
		$error .= 'パスワードが短すぎます(6文字以上)<br />';
	}
	
	if($error!=''){
		return plugin_qhmsetting_user2_form($error);
	}
	

	$usr = $_SESSION['usr'];
	$pw = '{x-php-md5}'.md5($passwd1);

	$users_data = _get_users_data();

	if( isset( $users_data[$usr] ) )
	{
		$users_data[$usr]['passwd'] = $pw;
	}
	
	$data = '';
	foreach($users_data as $key=>$value)
	{
		$data .= $key.','.$value['passwd']."\n";
	}
	
	_write_userfile($data, "w");
	
	$msg = '変更しました';
	return plugin_qhmsetting_user2_form($msg);
}


//--<ChmodForm>--
function plugin_qhmsetting_chmod_form($error = '')
{
	global $custom_meta, $script;
	global $other_plugins;
	$is_qhmpro = (isset($other_plugins) && count($other_plugins) > 0);
	$hlp_chmod = ($is_qhmpro) ? str_replace('%PAGE%','UserAuthSetting',QHMPRO_HELP_LINK) : '';

	$back_url = '';

	$dirs = array('attach','backup','cache','cacheqhm','counter','diff','trackback','wiki');
	$files = array('pukiwiki.ini.php', 'qhm_access.ini.txt', 'qhm_users.ini.txt');

	

	//書き込み権限のないファイル、apacheのみ書き込みファイル探し
	$not_writable = array();
	$not_writable_list = '';
	
	$web_file = array();
	$web_file_list = '';
	
	foreach($dirs as $dir)
	{
		$obj = dir($dir);
		while( ($file=$obj->read()) )
		{
			$path = $dir.'/'.$file;
			
			if( !is_writable($path) && ($file!='..') 
					&& ($file!='.htaccess') && ($file!='.htpasswd') && ($file!='index.html') )
			{
				$not_writable[] = $path;
				$not_writable_list .= '<li>'.$path.'</li>'."\n";				
			}
			
			if( is_writable($path) && ($file!='..') 
					&& ($file!='.htaccess') && ($file!='.htpasswd') && ($file!='index.html') )
			{
				$perms = substr(sprintf('%o', fileperms($path)), -4);
				if($perms == '0644')
				{
					$web_file[] = $path;
					$web_file_list .= '<li>'.$path.'</li>';
				}
			}
		}
		$obj->close();		
	}
	
	foreach($files as $path)
	{
		if( !is_writable($path) )
		{
			$not_writable[] = $path;
			$not_writable_list .= '<li>'.$path.'</li>'."\n";				
		}
		
		if( is_writable($path) )
		{
			$perms = substr(sprintf('%o', fileperms($path)), -4);
			if($perms == '0644')
			{
				$web_file[] = $path;
				$web_file_list .= '<li>'.$path.'</li>';
			}
		}
	}
	
	
	$not_writable_list = ($not_writable_list=='') ? 
		'' : '<ul>'.$not_writable_list.'</ul>';
		
	if($web_file_list!='')
	{
		$web_file_list = '<ul>'.$web_file_list.'</ul>';
		$web_file_list .= '<form method="post" action="'.$script.'">';
		
		$cnt = 0;
		foreach($web_file as $file){
			$web_file_list .= '<input type="hidden" name="webfile['.$cnt.']" value="'.$file.'" />'."\n";
			$cnt++;
		}
		$web_file_list .= '<p style="text-align:center;"><input type="submit" name="chmod" value="権限変更を実行する" /></p><input type="hidden" name="phase" value="chmod" />
<input type="hidden" name="mode" value="msg" />
<input type="hidden" name="plugin" value="qhmsetting" />';
		$web_file_list .= '</form>';
	
	}

	//apacheしか書けないファイル探し
	
	if ($not_writable_list == '') {
		$not_writable_list = '<div style="padding:5px;width:350px;background-color:#ddeeff;border:2px solid #6699CC;text-align:center;margin:1em auto;">書き込み権限に問題はありませんでした</div>';
	}
	else {
		$not_writable_list = '<p>以下のファイルは、QHMによって利用するにも関わらず、書き込みができません。<br />
FTPソフトなどを使って、書き込みを権限を設定して下さい</p>'.$not_writable_list;
	}
	
	if ($web_file_list == '') {
		$web_file_list = '<div style="padding:5px;width:350px;background-color:#ddeeff;border:2px solid #6699CC;text-align:center;margin:1em auto;">Webサーバーの書き込みに問題はありませんでした</div>';
	}
	else {
		$web_file_list = '<p>PHPの仕様上、PHPプログラムが作成したファイルは、webサーバー(apache)のみが、<br />
書き込み可能のファイルが作成されます。</p>
<p>使う上で問題はありませんが、削除できないファイルなどがある場合は、<b>権限変更</b>を<br />
実行することで、削除や変更、FTPによる上書きが可能になります。</p>'.$web_file_list;
	}
	

	$body = <<<EOD
{$back_url}
<h2>権限チェック{$hlp_chmod}</h2>
<h3>書き込み権限がないファイル</h3>
{$not_writable_list}
<br />
<h3>Webサーバーのみ書き込み可能</h3>
{$web_file_list}
EOD;

	
	return $body;
}

function plugin_qhmsetting_chmod_msg()
{
	global $vars, $script;
	
	$list = '<ul>';
	foreach($vars['webfile'] as $key=>$name)
	{
		chmod($name, 0666);
		$list .= '<li>'.$name."</li>\n";
	}
	$list .= '</ul>';

	$back_url = '<a href="'.$script.'?plugin=qhmsetting&amp;phase=chmod&amp;mode=form">戻る</a>';
	
	$body = <<<EOD
<p>$back_url</p>
<h2>完了</h2>
<p>以下のファイルの権限を変更しました。</p>
{$list}
<p>$back_url</p>
EOD;

	return $body;

}
//--</ChmodForm>--

function plugin_qhmsetting_counter_form($error='')
{
	global $script, $vars;
	global $other_plugins;
	$is_qhmpro = (isset($other_plugins) && count($other_plugins) > 0);
	$hlp_counter  = ($is_qhmpro) ? str_replace('%PAGE%','Counter',QHMPRO_HELP_LINK) : '';

	//reset 
	$message = '';
	if( isset($vars['reset']) )
	{
		$message = '<p style="color:red;text-align:center">リセットしました</p>';
		file_put_contents('counter/'.$vars['reset'],'');
	}


	$list = get_existpages('counter','.count');
		
	$body = <<<EOD
<h2>カウンターのリセット{$hlp_counter}</h2>
$message
<p>リセットしたいカウンターを選んで、「リセット」をクリックしてください。</p>
<ul>
EOD;
	
	foreach($list as $fname=>$pname)
	{
		$url = $script.'?'.rawurlencode($pname);
		$reset_url = $script.'?cmd=qhmsetting&amp;phase=counter&amp;mode=form&amp;reset='
			. rawurlencode($fname);
		
		$body .= '<li><a href="'.$url.'">'.$pname.
			'</a> <input type="button" value="リセット" onclick="javascript:location.href=\''
			.$reset_url.'\'"></li>'."\n";
	}
	
	$body .= '</ul>';
	
	return $body;
}

function plugin_qhmsetting_clear_form($error = '')
{
	global $custom_meta, $script, $enable_cache;
	global $other_plugins;
	$is_qhmpro = (isset($other_plugins) && count($other_plugins) > 0);
	$hlp_clear = ($is_qhmpro) ? str_replace('%PAGE%','SettingCache',QHMPRO_HELP_LINK) : '';

	$files = array();
	$files_cache = array();
	if ($dir = opendir(CACHE_DIR)) {
	    while (($file = readdir($dir)) !== false) {
	        if (preg_match('/\.qtc$/', $file)) {
	            $files[] = $file;
	        }
	    }
	    closedir($dir);
	}
	
	// キャッシュ設定
	if($enable_cache){
		$checked_cache = 'checked="checked"';
	}
	else{
		$checked_cache = '';
	}
	
	$body = <<<EOD
<h2>高速化設定、キャッシュ、テンプレートの初期化{$hlp_clear}</h2>
<p>高速化、表示に関する設定を行います。</p>
<h3>高速化設定（キャッシュ機能の有効化）</h3>
<p>QHMの表示をキャッシュ化して「高速化」することができます。<br />
※一部のプラグインを使ったページはキャッシュできません</p>
<form action="{$script}" method="post">
<p><input type="checkbox" {$checked_cache} name="enable_cache" /> 高速化設定を有効にする</p>
<input type="submit" name="cache_setting" value="設定する" />
<input type="hidden" name="phase" value="clear" />
<input type="hidden" name="mode" value="msg" />
<input type="hidden" name="cmd" value="qhmsetting" />
</form>
<h3 style="margin-top:2em;">高速化キャッシュの削除</h3>
<form action="{$script}" method="post">
<p>高速化のための全ページをキャッシュを初期化します。更新したページが、更新されない、正常に動作しないときに実行してください。</p>
<input type="submit" name="cache_del" value="キャッシュの初期化を実行" />
<input type="hidden" name="phase" value="clear" />
<input type="hidden" name="mode" value="msg" />
<input type="hidden" name="cmd" value="qhmsetting" />
</form>

<h3 style="margin-top:2em;">テンプレートキャッシュの初期化</h3>
<p>テンプレートキャッシュを削除します。<br />
削除を行うことで、ページ全体のレイアウトを再構築できます。</p>
<form action="{$script}" method="post">
<ul>
EOD;
	$cnt = 0;
	foreach($files as $file){
		$rm_file = CACHE_DIR.$file;
		$body .= "<li>{$rm_file}<input type=\"hidden\" name=\"rm[{$cnt}]\" value=\"{$rm_file}\" /></li>\n";
		$cnt ++;
	}
	$body .= <<<EOD
</ul>
<p style="text-align:center"><input type="submit" name="clear" value="　削除を実行　" /></p>
<input type="hidden" name="tmp_del" value="tmp_del" />
<input type="hidden" name="phase" value="clear" />
<input type="hidden" name="mode" value="msg" />
<input type="hidden" name="cmd" value="qhmsetting" />
</form>
EOD;
	
	return $body;
}


function plugin_qhmsetting_clear_msg($error = '')
{
	global $vars, $script;
	$error = '';
	
	//----------------- テンプレートの削除 ---------------
	if( isset($vars['tmp_del']) )
	{
		foreach($vars['rm'] as $rm_file)
		{
			if(file_exists($rm_file) && is_writable($rm_file)){
				unlink($rm_file);
						
			}
			else{
				$error .= $rm_file."\n";
			}
		}
		
		$log_msg = $error==='' ? 
			'' 
			: nl2br('削除できなかったファイル'."\n".$error);
		
		$body = <<<EOD
<h2>削除を完了しました</h2>
<p>テンプレートキャッシュを削除しました</p>
$log_msg
<p><a href="{$script}?cmd=qhmsetting">設定に戻る</a></p>
EOD;
		return $body;
	}
	
	//-------------------- キャッシュ機能の設定 ------------
	if( isset($vars['cache_setting']) )
	{
		if( isset($vars['enable_cache']) )
		{
			$_SESSION['qhmsetting']['enable_cache'] = 1;
			$msg = '有効にしました。';
		}
		else{
			$_SESSION['qhmsetting']['enable_cache'] = 0;		
			$msg = '無効にしました。';
		}
		
		plugin_qhmsetting_update_ini();
		
		return '<p>キャッシュ機能を、'.$msg.'</p>'.'<p><a href="'.$script.'?cmd=qhmsetting">設定に戻る</a></p>';
	}
	
	//-------------------- キャッシュの削除 ---------------
	if( isset($vars['cache_del']) )
	{
		$files = array();
		if ($dir = opendir(CACHE_DIR)) {
		    while (($file = readdir($dir)) !== false) {
		        if (preg_match('/\.(tmp|tmpr)$/', $file)) {
		            $files[] = $file;
		            unlink(CACHE_DIR.$file);
		        }
		    }
		    closedir($dir);
		}
		
		return '<p><a href="'.$script.'?cmd=qhmsetting">設定に戻る</a></p>
<p>以下のファイルを削除しました</p>
<ul>
<li>'
.implode('</li><li>', $files).
'</li>
</ul>
';
	}
}



//--<CloseForm>--
function plugin_qhmsetting_close_form($error = '')
{
	global $script, $site_close_all;
	global $other_plugins;
	$is_qhmpro = (isset($other_plugins) && count($other_plugins) > 0);
	$hlp_close = ($is_qhmpro) ? str_replace('%PAGE%','SettingCloseSite',QHMPRO_HELP_LINK) : '';
	
	if($site_close_all){
		$checked_close = 'checked="checked"';
		$checked_open = '';
	}
	else{
		$checked_close = '';
		$checked_open = 'checked="checked"';
	}
	
	$body = <<<EOD
<h2>サイト全体を閉鎖{$hlp_close}</h2>
<p>大幅なサイトの編集、変更を行う場合などに、「サイト全体」を閉鎖することができます。閉鎖中は、管理者のみがログイン可能になります。</p>
<form action="{$script}" method="post">
<p>
 <input type="radio" {$checked_open} name="qhmsetting[site_close_all]" value="false" /> 公開<br />
 <input type="radio" {$checked_close} name="qhmsetting[site_close_all]" value="true" /> 閉鎖
</p>
<input type="submit" name="cache_setting" value="設定する" />
<input type="hidden" name="phase" value="close" />
<input type="hidden" name="mode" value="msg" />
<input type="hidden" name="cmd" value="qhmsetting" />
</form>
<p>設定を押すと、即時に反映します。</p>
EOD;
	
	return $body;
}

function plugin_qhmsetting_close_msg($error = '')
{
	global $script, $site_close_all, $vars;


	//サイト閉鎖
	if( isset($vars['qhmsetting']['site_close_all']) && $vars['qhmsetting']['site_close_all']=='true')
	{
		$msg = 'サイトを閉鎖しました。';
		$_SESSION['qhmsetting']['site_close_all'] = 1;
	}
	else
	{
		$msg = 'サイトを公開しました。';
		$_SESSION['qhmsetting']['site_close_all'] = 0;
	}
	
	plugin_qhmsetting_update_ini();
	
	$body = <<<EOD
<h2>サイト全体を閉鎖（公開）</h2>
<p>$msg</p>

EOD;
	
	return $body;

}
//--</CloseForm>--


/**
* モバイル転送
*/
function plugin_qhmsetting_mobile_form($error = '')
{
	global $script, $vars;
	global $other_plugins;
	$is_qhmpro = (isset($other_plugins) && count($other_plugins) > 0);
	$hlp_mobile = ($is_qhmpro) ? str_replace('%PAGE%','RedirectMobile',QHMPRO_HELP_LINK) : '';
	
	$params = plugin_qhmsetting_getparams();
		
	$error_msg .= ($error!='') ? '<p style="color:red">'.$error.'</p>' : '';
	
	$body = <<<EOD
<h2>携帯端末アクセスの転送先{$hlp_mobile}</h2>
<p>以下にURLを指定して下さい。なお、空を設定すると転送しません。</p>
{$error_msg}
<form method="post" action="{$script}">
<table class="style_table" cellspacing="1" border="0">
	<tr>
		<th class="style_th">　転送先URL　</th>
		<td class="style_td">　<input type="text" name="qhmsetting[mobile_redirect]" size="50" value="{$params['mobile_redirect']}"  />　</td>
	</tr>
</table>

<p style="text-align:center"><input type="submit" value="設定する" style="font-size:16px" onclick="return confirm('設定を実行しますか？');" /></p>
<input type="hidden" name="phase" value="mobile" />
<input type="hidden" name="mode" value="msg" />
<input type="hidden" name="plugin" value="qhmsetting" />
</form>

EOD;

	return $body;
}

function plugin_qhmsetting_mobile_msg()
{
	global $vars, $script;
		
	$url = $_SESSION['qhmsetting']['mobile_redirect'] = $vars['qhmsetting']['mobile_redirect'];

	if(! is_url($url) && $url!='' ){
		return plugin_qhmsetting_mobile_form('URLが不正です。正しいものを入力してください。');
	}

	plugin_qhmsetting_update_ini();

	$ret =  <<<EOD
<h2>転送設定完了</h2>
<p>%REP%</p>
<p><a href="{$script}?plugin=qhmsetting" style="font-weight:bold;background-color:#ff6;">戻る</a></p>
EOD;
		
	if($url == ''){
		return str_replace('%REP%', '携帯端末からのアクセスを転送しません。' , $ret);
	}
	else{
		return str_replace('%REP%', '携帯端末からのアクセスを「'.$url.'」に転送します。', $ret);
	}
}



/**
* Googleマップキーの設定
*/
function plugin_qhmsetting_gmap_form($error = '')
{
	global $script, $vars;
	global $other_plugins;
	$is_qhmpro = (isset($other_plugins) && count($other_plugins) > 0);
	$hlp_gmap = ($is_qhmpro) ? str_replace('%PAGE%','GoogleMapsKey',QHMPRO_HELP_LINK) : '';
	
	$params = plugin_qhmsetting_getparams();
		
	$error_msg .= ($error!='') ? '<p style="color:red">'.$error.'</p>' : '';
	
	$body = <<<EOD
<h2>Googleマップのキーを設定します{$hlp_gmap}</h2>
<p>Google Maps API Keyを<a href="http://code.google.com/intl/ja/apis/maps/signup.html" target="new">こちらから</a>取得して設定してください。</p>
{$error_msg}
<form method="post" action="{$script}">
<table class="style_table" cellspacing="1" border="0">
	<tr>
		<th class="style_th">　Key　</th>
		<td class="style_td">　<input type="text" name="qhmsetting[googlemaps_apikey]" size="50" value="{$params['googlemaps_apikey']}"  />　</td>
	</tr>
</table>

<p style="text-align:center"><input type="submit" value="設定する" style="font-size:16px" onclick="return confirm('設定を実行しますか？');" /></p>
<input type="hidden" name="phase" value="gmap" />
<input type="hidden" name="mode" value="msg" />
<input type="hidden" name="plugin" value="qhmsetting" />
</form>

EOD;

	return $body;
}

/**
* Googleマップキーの設定
*/
function plugin_qhmsetting_gmap_msg()
{
	global $vars, $script;
		
	$_SESSION['qhmsetting']['googlemaps_apikey'] 
		= str_replace("'", "\'", $vars['qhmsetting']['googlemaps_apikey']);

	plugin_qhmsetting_update_ini();

	return <<<EOD
<h2>転送設定完了</h2>
<p>Google Maps API Keyを設定しました。<br />
{$vars['qhmsetting']['googlemaps_apikey']}</p>
<p><a href="{$script}?plugin=qhmsetting" style="font-weight:bold;background-color:#ff6;">戻る</a></p>
EOD;
}

/**
* スクリプトのパスの設定
*/
function plugin_qhmsetting_script_form($error = '')
{
	global $script;

	$sts = '<div style="border:2px solid #66AACC;background-color:#EEEEFF;margin:1.5em auto;padding:0 10px;width:90%;text-align:left;"><p>現在設定されているURL：<br />'.$script.'</p></div>';

	$body = <<<EOD
<script type="text/javascript">
<!--
window.onload = function() {
	var href = location.href.replace(location.search, '');
	document.getElementById('op_script').value = href;
	document.getElementById('frm_script').action = href;
}
// -->
</script>
<h2>リンクが正常に動作しないサーバーの設定</h2>
<p>リンクが正常に動作するように、ホームページのURLを設定します。<p/>
<p>「現在設定されているURL」と「ホームページのURL」が異なっている場合は、ユーザー名とパスワードを入力して「設定」を行ってください。</p>
{$sts}
<p style="color:red">{$error}</p>
<form method="post" action="" id="frm_script" name="frm_script">

<table class="style_table" cellspacing="1" border="0" style="font-size:12px">
	<tr>
		<th class="style_th">　ホームページのURL　</th>
		<td class="style_td">　<input type="text" id="op_script" name="op_script" size="50" value="" />　<br />
		<p>「 http://あなたのホームページアドレス/index.php 」と入力します<br />例：http://hogehoge.com/index.php</p></td>
	</tr>
	<tr>
		<th class="style_th">　ユーザー名　</th>
		<td class="style_td">　<input type="text" name="op_username" size="18" />　</td>
	</tr>
	<tr>
		<th class="style_th">　パスワード　</th>
		<td class="style_td">　<input type="password" name="op_passwd" size="18" /></td>
	</tr>
</table>
<p style="text-align:center"><input type="button" name="back" value="戻　る" onclick="location.href = location.href.replace(location.search, '') + '?cmd=qhmauth';" />　　<input type="submit" name="setscript" value="設　定" /></p>
<input type="hidden" name="plugin" value="qhmsetting" />
<input type="hidden" name="phase" value="script" />
<input type="hidden" name="mode" value="msg" />
</form>
<br />
<div style="border:2px dotted #CCC;background-color:#eee;margin:1.5em auto;padding:0 10px;width:90%;text-align:left;">
<p>サーバーの変更や誤った設定をした場合などに、設定を初期化する必要があります。<br />
初期化するには、「ホームページのURL」を空白にして「設定」を行います。</p>
</div>
EOD;
	
	return $body;
}

function plugin_qhmsetting_script_msg()
{
	global $vars, $script, $username, $auth_users;
	$msg = '';

	// --------------------------------------
	// reset passwd
	$msg = "リンクが正常に動作しないサーバー用の設定をしました";
	$oppasswd  = $vars['op_passwd'];
	$opusername = $vars['op_username'];
	$opscript = $vars['op_script'];

	//error
	$error = '';
	if ( $username != $opusername) {
		$error = 'ユーザー名が一致しません。<br />';
	}

	if( $auth_users[$username] != '{x-php-md5}'.md5($oppasswd) ){
		$error .= 'パスワードが一致しません。<br />';
	}
	if($opscript != '' && !is_url($opscript)){
		$error .= 'URLが正しくありません。<br />';
	}
	
	if($error!=''){
		return plugin_qhmsetting_script_form($error);
	}


	$_SESSION['qhmsetting']['script'] = $opscript;
	plugin_qhmsetting_update_ini();

	header('location: '.$opscript.'?cmd=qhmauth');
	exit;
//	$msg = '変更しました';
//	return plugin_qhmsetting_script_form($msg);
}

/**
* session save path の設定
*/
function plugin_qhmsetting_sssavepath_form($error = '')
{
	global $script, $session_save_path;
	$save_dir = CACHEQHM_DIR;
	
	$sts = '';
	$btn = '<input type="submit" id="set" name="set" value="設　定" />';
	if ($session_save_path != '') {
		$sts = '<div style="border:2px solid #66AACC;background-color:#EEEEFF;margin:5px auto;padding:0 10px;width:90%;text-align:center;"><p>現在、QHM内にセッションの保存先が設定されています。<br />設定を元に戻す場合は、「解除」を行ってください。</p></div>';
		$btn = '<input type="submit" id="unset" name="unset" value="解　除" />';
	}

	$body = <<<EOD
<h2>セッションが正常に動作しないサーバーの設定</h2>
<p>サーバー側でセッションの保存先が正しく設定されていない場合、QHMの認証ができません。<br />そこで、対処法としてQHM内にセッションを保存します。（フォルダ：{$save_dir}）</p>
{$sts}
<p style="color:red">{$error}</p>
<form method="post" action="{$script}" id="frm_script" name="frm_script">

<table class="style_table" cellspacing="1" border="0">
	<tr>
		<th class="style_th">　ユーザー名　</th>
		<td class="style_td">　<input type="text" name="op_username" size="18" />　</td>
	</tr>
	<tr>
		<th class="style_th">　パスワード　</th>
		<td class="style_td">　<input type="password" name="op_passwd" size="18" /></td>
	</tr>
</table>
<p style="text-align:center"><input type="button" name="back" value="戻　る" onclick="location.href='{$script}?cmd=qhmauth';" />　　{$btn}　</p>

<input type="hidden" name="plugin" value="qhmsetting" />
<input type="hidden" name="phase" value="sssavepath" />
<input type="hidden" name="mode" value="msg" />
</form>
<br />
EOD;
	
	return $body;
}

function plugin_qhmsetting_sssavepath_msg()
{
	global $vars, $script, $username, $auth_users;
	$msg = '';

	// --------------------------------------
	// reset passwd
	$msg = "セッションが正常に動作しないサーバー用の設定をしました";
	$oppasswd  = $vars['op_passwd'];
	$opusername = $vars['op_username'];

	//error
	$error = '';
	if ( $username != $opusername) {
		$error = 'ユーザー名が一致しません。<br />';
	}

	if( $auth_users[$username] != '{x-php-md5}'.md5($oppasswd) ){
		$error .= 'パスワードが一致しません。<br />';
	}
	
	if($error!=''){
		return plugin_qhmsetting_sssavepath_form($error);
	}
	
	if (isset($vars['set'])) {
		$_SESSION['qhmsetting']['session_save_path'] = CACHEQHM_DIR;
	}
	else if (isset($vars['unset'])) {
		$_SESSION['qhmsetting']['session_save_path'] = '';
	}

	plugin_qhmsetting_update_ini();

	header('location: '.$script.'?cmd=qhmauth');
	exit;

//	$msg = '変更しました';
//	return plugin_qhmsetting_script_form($msg);
}


/**
* 現在の設定ファイルの値を取得して、
* $_SESSION['qhmsetting']の値で上書きして、pukiwiki.ini.phpを上書きする
*/
function plugin_qhmsetting_update_ini()
{

	$exclude_slashes = array(
		'modifier'     => 1,
		'modifierlink' => 1,
		'reg_exp_host' => 1,
//		'custom_meta'=>'dummy', 
//		'accesstag'=>'dummy', 
	);

	$han2zen = array(
		'page_title'=>'dummy',
		'owneraddr'=>'dummy',
		'ownertel' =>'dummy',
		'headcopy' =>'dummy',
		'keywords' =>'dummy',
		'description' =>'dummy',
	);

	$params = plugin_qhmsetting_getparams();
	
	//update
	$pattern = array();
	$rep = array();
	foreach($params as $key=>$val)
	{
		$pattern[] = '/%'.$key.'%/';
		
		if( isset($exclude_slashes[$key]) )
			$val = str_replace("'", "\'", $val); //「'」をエスケープ

		if ( isset($han2zen[$key]) )
			$val = str_replace('"', '”', $val); //「"」を「”」全角に
		
		$rep[] = $val;			
	}
	
	$contents = file_get_contents(PLUGIN_QHMSETTING_INI_SRC);
	$contents = preg_replace($pattern, $rep, $contents);
	
//	echo $contents;
//	exit;
	
	return file_put_contents('pukiwiki.ini.php', $contents);
}

/**
* pukiwiki.ini.php の設定項目のすべてを paramsにセットし、
* $_SESSION['qhmsetting']の値で上書きして、returnする。
*/
function plugin_qhmsetting_getparams($update=TRUE, $inifile = '')
{

/*	global $style_type, $style_name, $page_title, $page_title, $logo_image;
	global $owneraddr, $ownertel, $headcopy, $keywords, $description, $nowindow;
	global $custom_meta, $qhm_adminmenu, $accesstag, $modifier, $modifierlink, $modifierlink;
	global $username, $passwd;
	global $notify, $notify_diff_only, $smtp_server, $notify_to, $notify_from;
	global $smtp_auth, $pop_server, $pop_userid, $pop_passwd ;
	global $google_apps, $google_apps_domain;
	global $script;*/
	
	if($inifile == ''){
		require(INI_FILE);
	}
	else{
		require($inifile);
	}

	
	$params = array(
		//デザイン設定で使う
		'style_type'	=>$style_type,
		'style_name'	=>$style_name,
		'logo_image'	=>$logo_image,
		'page_title'	=>$page_title,
		'enable_wp_theme' => $enable_wp_theme,
		'enable_wp_theme_name' => $enable_wp_theme_name,
		'wp_add_css'	=> $wp_add_css,
		//サイト情報設定
		'owneraddr'		=>$owneraddr, 
		'ownertel'		=>$ownertel, 
		'headcopy'		=>$headcopy, 
		'keywords'		=>$keywords, 
		'description'	=>$description,
		'custom_meta'	=>$custom_meta,
		'qhm_adminmenu'	=>$qhm_adminmenu,
		'accesstag'		=>$accesstag,
		'modifier'		=>$modifier,
		'modifierlink'	=>$modifierlink,
		'nowindow'		=>$nowindow,
		//ユーザー管理
		'username'		=>$username,
		'passwd'		=>$passwd,
		//メール設定
		'notify'		=>$notify, 
		'notify_diff_only'	=>$notify_diff_only, 
		'smtp_server'	=>$smtp_server, 
		'notify_to'		=>$notify_to, 
		'notify_from'	=>$notify_from,
		'smtp_auth'		=>$smtp_auth,
		'pop_server'	=>$pop_server, 
		'pop_userid'	=>$pop_userid,
		'pop_passwd'	=>$pop_passwd,
		//GoogleApps
		'google_apps'	=>$google_apps,
		'google_apps_domain'	=>$google_apps_domain,
		//特別設定
		'script'		=>$script,
		'no_qhm_licence'   =>$no_qhm_licence,
		'qhm_access_key'=>$qhm_access_key,
		'reg_exp_host'=>$reg_exp_host,
		'enable_cache'=>$enable_cache,
		'autolink'=>$autolink,
		'session_save_path'=>$session_save_path,
		//サイトの閉鎖
		'site_close_all'=>$site_close_all,
		'mobile_redirect'=>$mobile_redirect,
		'googlemaps_apikey'=>$googlemaps_apikey,
	);
	
	
	//set default data
	$params['qhm_adminmenu']    = $params['qhm_adminmenu']==='' ? 1 : $params['qhm_adminmenu'];
	$params['nowindow']         = $params['nowindow']==='' ? 0 : $params['nowindow'];
	$params['notify']           = $params['notify']==='' ? 0 : $params['notify'];
	$params['notify_diff_only'] = $params['notify_diff_only']==='' ? 1 : $params['notify_diff_only'];
	$params['smtp_auth']        = $params['smtp_auth']==='' ? 0 : $params['smtp_auth'];
	$params['no_qhm_licence']   = $params['no_qhm_licence']==='' ? 0 : $params['no_qhm_licence']; 
	$params['qhm_access_key']   = $params['qhm_access_key']==='' ? 1 : $params['qhm_access_key'];
	$params['enable_cache']     = $params['enable_cache']=='' ? 0 : $params['enable_cache'];
	$params['site_close_all']   = $params['site_close_all']=='' ? 0 : $params['site_close_all'];
	$params['enable_wp_theme']  = $params['enable_wp_theme']=='' ? 0 : $params['enable_wp_theme'];
	$params['wp_add_css']  		= $params['wp_add_css']=='' ? '' : $params['wp_add_css'];
	
	if($update && isset($_SESSION['qhmsetting']))
	{
		//set up new params
		foreach($_SESSION['qhmsetting'] as $key=>$val)
		{
			$params[$key] = $val;
		}
	
		//セッションのクリアー
		unset($_SESSION['qhmsetting']);
	}
	
	return $params;
}

function _get_type_name($mark) {
	$ret = "";
	switch ($mark) {
	case "r":
		$ret = "閲覧制限";
		break;
	case "e":
		$ret = "編集許可";
		break;
	default:
		$ret = "閲覧制限";
		break;
	}
	return $ret;
}

function _get_users_data()
{
	//user dataの取得
	$users_data = array();
	$fp = fopen(QHM_USER_INI_FILE, "r");
	if ($fp) {
		flock( $fp, LOCK_SH );
		
		while (!feof($fp)) {
			$line = fgets($fp);
			if (trim($line)) {
				list($name,$passwd) = explode(',', $line);
				if ($name != ""){
					$users_data[trim($name)] = array("passwd"=>trim($passwd));
				}
			}
		}
		fclose($fp);
	}
	
	return $users_data;

}

function _get_accessdata() {
	$access_data = array();

	$fp = fopen(QHM_ACCESS_INI_FILE, "r");
	if ($fp) {
		flock( $fp, LOCK_SH );
		
		while (!feof($fp)) {
			$line = fgets($fp);
			if (trim($line) != "") {
				list($type,$pattern,$name) = explode(',', $line);
				$access_data[] = array("type"=>trim($type), "pattern"=>$pattern, "user"=>trim($name));
			}
		}
		fclose($fp);
	}

	return $access_data;
}

function _add_del($data) {
	return $data . ",";
}

function _check_userdata($params) {

	global $username;
	
	$error = '';
	foreach ($params as $key=>$value) {

		switch ($key) {
		case "username":
			$title = 'ユーザー名';
			break;
		case "passwd":
			$title = 'パスワード';
			break;
		case "repasswd":
			$title = 'パスワード(確認)';
			break;
		}

		if (!preg_match( '/^[0-9a-zA-Z]+$/', $value) ) {
			// 半角英数字
			$error .= $title."は半角英数字で入力してください<br />";
		}
	}
	
	if($params['passwd'] != $params['repasswd'] )
	{
		$error .= 'パスワードと、確認が一致しません。<br />';
	}
	
	if( $params['username'] == $username )
	{
		$error .= '管理者名と重複しています<br />';
	}
	
	return $error;
}

function _write_userfile($stream, $mode) {
	// ファイルの作成
	$fp  = fopen(QHM_USER_INI_FILE, $mode);
	flock( $fp, LOCK_EX );
	
	if($mode==='w'){
		ftruncate($fp, 0); 
		rewind($fp); 
	}
	
	if ($fp) {
		fwrite($fp, $stream);
		fclose($fp);
		chmod(QHM_USER_INI_FILE, 0666);
	}
}

function _write_accessfile($stream, $mode) {
	// ファイルの作成
	$fp  = fopen(QHM_ACCESS_INI_FILE, $mode); // ファイルの読込み
	flock( $fp, LOCK_EX );
	
	if($mode==='w'){
		ftruncate($fp, 0); 
		rewind($fp); 
	}

	if ($fp) {
		fwrite($fp, $stream);
		fclose($fp);
		chmod(QHM_ACCESS_INI_FILE, 0666);
	}
}

function _get_pregdata($data, $mark) {
	switch ($mark) {
	case "front":
		$data = "/^".$data.".*/";
		break;
	case "back":
		$data = "/.*".$data."$/";
		break;
	case "part":
		$data = "/.*".$data.".*/";
		break;
	case "all":
		$data = "/^".$data."$/";
		break;
	default:
		break;
	}
	
	return $data;
}


function plugin_qhmsetting_club_auth() {
	global $vars, $other_plugins;
	$email = $vars['email'];
	$vars['password'] = $passwd = sha1(md5($vars['password']));
	$vars['product_id'] = 1;//QHM Product ID

	//QHM ライセンスを確認
	$data = http_build_query($vars);
	$res = trim(plugin_qhmsetting_post(PLUGIN_QHMSETTING_CLUB_URL . 'users/remote_has_product/'.QHM_REVISION.'/' , $data));
	$rawres = $res;
	$pid = preg_match('/<product_id>(\d+)<\/product_id>/', $res, $mts)? intval($mts[1]): 0;
	$res = preg_match('/<result>(.+)<\/result>/', $res, $mts)? $mts[1]: $res;

	$club_id = 0;
	$errmsg = '';
	//QHM 購入してない
	if($res == 'invalid') {
		$club_id = 0;
		$errmsg = $pid == 1? 'QHMプロのライセンス未購入です': ($pid == 10? '体験版QHMプロの有効期限が過ぎています': ($other_plugins? 'QHMプロのライセンス未購入です': 'Open QHMではデザインの取得はできません'));
	}
	//認証エラー
	else if($res == 'auth_error') {
		$club_id = 0;
		$errmsg = 'メールアドレス、あるいはパスワードが間違っています';
	}
	//club_id
	else if (preg_match('/^\d+$/', $res)) {
		$club_id = $res;
	} else {
		$club_id = 0;
		$errmsg = '予期せぬメッセージです。<a href="'.PLUGIN_QHMSETTING_CLUB_URL.'users/contact/" target="new">こちら</a>から問い合わせてください<!--'. strip_tags($rawres) .'-->';
	}
	

	if ($errmsg == '') {
		//セッションに格納
		$_SESSION['remote_club'] = array(
			'club_id'  => $club_id,
			'email'    => $email,
			'password' => $passwd,
			'product_id' => $pid,
		);
		$out =  'valid';
	} else {
		$out = $errmsg;
	}
	header("Content-Type: application/text; charset=UTF-8");
	echo '<result>', $out, '</result>';
	exit;
}

//--<FTPAccess>--
/**
 *   localhost にFTP接続し、フォルダを作る
 */
function plugin_qhmsetting_ftp_access() {
	global $vars;
	
	$club_data = isset($_SESSION['remote_club'])? $_SESSION['remote_club']: array();
	
	$out = '';
	if ($club_data) {
		$username = $vars['username'];
		$password = $vars['password'];
		$dir = $vars['use_dir']? $vars['dir']: FALSE;
		$design = preg_match('/^[\w_]+$/', trim($vars['design_name']))? $vars['design_name']: '';
		$path = getcwd();//qhm path
		if ($design) {
			if ($conn_id = ftp_connect('localhost', 21)) {
				$login = ftp_login($conn_id, $username, $password);
				if ($login) {
					ftp_pasv($conn_id, true);
					//設置先フォルダが指定された場合、絶対パスかどうか判定する
					if ($dir !== FALSE && $dir[0] != '/') {
						$dir = ftp_pwd($conn_id). $dir;
					}
					$designdir = ($dir? $dir: $path). '/skin/hokukenstyle/';
					if (ftp_chdir($conn_id, $designdir)) {
						ftp_mkdir($conn_id, $design);
						ftp_chmod($conn_id, 0777, $designdir. $design);
						$out = 'OK';
					} else {
						$out = 'NG_Dir';
					}
					
				
				} else {
					$out .= 'FTPアカウント、あるいはパスワードが間違っています';
				}
				
				ftp_close($conn_id);
			} else {
				$out .= 'FTP接続できません';
			}
		} else {
			$out .= 'デザイン名が不正です';
		}
		
	} else {
		$out .= '北研クラブに認証されていません';
	}
	header("Content-Type: application/text; charset=UTF-8");
	echo '<result>', $out, '</result>';
	exit;

}
//--</FTPAccess>--



function plugin_qhmsetting_club_has_qhm()
{
	global $vars;
	$club_data = isset($_SESSION['remote_club'])? $_SESSION['remote_club']: array();
	
	header("Content-Type: application/text; charset=UTF-8");
	if ($club_data) {
		echo "<result>valid</result>";
	} else {
		echo "<result>invalid</result>";
	}

	if (ini_get('safe_mode')) {
		echo '<safe_mode>1</safe_mode>';
	}
	exit;
}

//--<GetQHMDesign>--
function plugin_qhmsetting_club_get_designs()
{
	global $vars;
	$club_data = isset($_SESSION['remote_club'])? $_SESSION['remote_club']: array();
	
	if ($club_data) {
		$vars['email'] = $club_data['email'];
		$vars['password'] = $club_data['password'];
		$data = http_build_query($vars);
		$res = trim(plugin_qhmsetting_post(PLUGIN_QHMSETTING_CLUB_URL . 'users/get_qhm_designs/'.QHM_REVISION.'/', $data));
		$res = preg_match('/<json>(.*)<\/json>/', $res, $mts)? $mts[1]: '{}';
		header("Content-Type: application/json; charset=UTF-8");
		echo '<json>', $res, '</json>';
	} else {
		header("Content-Type: application/json; charset=UTF-8");
		echo '<json>{}</json>';
	}
	
	exit;
}

function plugin_qhmsetting_club_download_design()
{
	global $vars;
	$club_data = isset($_SESSION['remote_club'])? $_SESSION['remote_club']: array();
	
	if ($club_data) {
		$vars['email'] = $club_data['email'];
		$vars['password'] = $club_data['password'];
		$data = http_build_query($vars);
		$res = trim(plugin_qhmsetting_post(PLUGIN_QHMSETTING_CLUB_URL . 'users/download_qhm_design/'.QHM_REVISION.'/', $data));
		$len = strlen($res);
		//zip を保存
		if ($len > 0) {
			$d = $vars['design'];
			chdir('skin/hokukenstyle');
			$zipfile = '../../cacheqhm/'. $d. '.zip';
			$fp = fopen($zipfile, 'wb');
			fwrite($fp, $res, $len);
			fclose($fp);
			
			//zip を解凍する
			require_once("../../lib/unzip.lib.php");
			$unzip = new SimpleUnzip($zipfile);

			//mkdir
			mkdir($d);
			chmod($d, 0777);
			$len = $unzip->Count();
			for ($i = 0; $i < $len; $i++) {
				$name = $unzip->GetName($i);
				$data = $unzip->GetData($i);
				$dlen = strlen($data);
				
				$uzfile = $d . '/'. $name;
				if ($fp = fopen($uzfile, "wb")) {
					fwrite($fp, $data, $dlen);
					fclose($fp);
					chmod($uzfile, 0666);
				} else {
					echo '<error>', $name, ' is cannot opened!</error>';
				}
			}
			
			//remove zipfile
			unlink($zipfile);
			$out = 'OK';
		} else {
			$out = 'failed';
		}
	} else {
		$out = 'authenticate error';
	}
	header("Content-Type: application/text; charset=UTF-8");
	echo '<result>', $out, '</result>';
	exit;
}
//--</GetQHMDesign>--

function plugin_qhmsetting_post($url, $data, $optional_headers = null) {
	if(function_exists('stream_get_contents')){
		$params = array(
			'http' => array(
				'method' => 'POST',
				'content' => $data
			)
		);
		
		if ($optional_headers !== null) {
			$params['http']['header'] = $optional_headers;
		}
		$ctx = stream_context_create($params);
		
		$fp = @fopen($url, 'rb', false, $ctx);
		
		//ストリームオープン失敗
		if (!$fp) {
			//echo "Problem with $url, $php_errormsg";
			return false;
		}
		
		$response = @stream_get_contents($fp);
		//echo '<br />';
		//読み込み失敗
		if ($response === false) {
			//echo "Problem reading data from $url, $php_errormsg";
		}
		return $response;
	}
	else if(!function_exists('stream_get_contents')) {
		
		$url_parse = parse_url($url);
		$port = $url_parse['scheme'] == 'http'? "80": '443';
		
		if ($fp = fsockopen($url_parse['host'], $port)) {
			fputs ($fp, "POST ".$url_parse['path']." HTTP/1.1\r\n");
			fputs ($fp, "User-Agent:PHP/".phpversion()."\r\n");
			fputs ($fp, "Host: ".$_SERVER["HTTP_HOST"]."\r\n");
			fputs ($fp, "Content-Type:
			application/x-www-form-urlencoded\r\n");
			fputs ($fp, "Content-Length: ".strlen($data)."\r\n\r\n");
			fputs ($fp, $data);
			while (!feof($fp)) {
				$response .= fgets($fp, 4096);
			}
			fclose($fp);
		}
		return $response;
	}
}


if (!function_exists('http_build_query')) {
/**
 *   @sea http://php.net/manual/ja/function.http-build-query.php
 */
function http_build_query($data, $prefix='', $sep='', $key='') {
	$ret = array();
	foreach ((array)$data as $k => $v) {
		if (is_int($k) && $prefix != null) {$k = urlencode($prefix . $k);}
		if (!empty($key)) {$k = $key.'['.urlencode($k).']';}
		
		if (is_array($v) || is_object($v)) {
			array_push($ret, http_build_query($v, '', $sep, $k));
		}
		else {array_push($ret, $k.'='.urlencode($v));}
	}
	
	if (empty($sep)) {$sep = ini_get('arg_separator.output');}
	
	return implode($sep, $ret);
}
}


?>
