<?php
// PukiWiki - Yet another WikiWikiWeb clone.
// $Id: read.inc.php,v 1.8 2005/01/15 13:57:07 henoheno Exp $
//
// Read plugin: Show a page and InterWiki
// 
// * 過去のURLからの引っ越しを支援
//   EUC-JPのページ名指定の場合、301ヘッダーを出して、UTF-8エンコーディングしてリダイレクト
//   もし、ページがなければ、編集となるだろう・・・
//
function plugin_read_action()
{
	global $vars, $_title_invalidwn, $_msg_invalidiwn, $script;
	global $_msg_notfoundpage_title, $_msg_notfoundpage;
	global $post;
	global $enable_cache;
	
	$page = isset($vars['page']) ? $vars['page'] : '';

	//キャッシュを無効化
	if( isset($vars['word']) )
		$enable_cache = false;

	if (is_page($page)) {
		// ページを表示
		check_readable($page, true, true);
		header_lastmod($page);
		return array('msg'=>'', 'body'=>'');

	} else if (! PKWK_SAFE_MODE && is_interwiki($page)) {
		return do_plugin_action('interwiki'); // InterWikiNameを処理

	} else if (is_pagename($page)) {
		$vars['cmd'] = 'edit';

		// 編集権限があれば、編集モードへ。なければ、メッセージを表示
		$editable = edit_auth($page, FALSE, FALSE);
		if($editable){
			return do_plugin_action('edit'); // 存在しないので、編集フォームを表示
		}
		else{
		
			//実験的
			require_once('plugin/search.inc.php');
			$res = "<hr />\n"."<p>関連ページを検索しました</p>".plugin_search2_do_search($page);
			return array(
				'msg'=>$_msg_notfoundpage_title,
				'body'=>str_replace('$1', $script, $_msg_notfoundpage.$res)
			);
		}
		
	} else {
		//EUCエンコーディングかチェック
		if(mb_detect_encoding($post['page'], 'UTF-8,EUC-JP')=='EUC-JP')
		{
			$u_page = mb_convert_encoding($post['page'], 'UTF-8', 'EUC-JP');
			$enc_page = rawurlencode($u_page);
			
			//redirect
			header("HTTP/1.1 301 Moved Permanently");
			header('Location: '.$script.'?'.$enc_page);
			exit;
		}
	
		// 無効なページ名
		return array(
			'msg'=>$_title_invalidwn,
			'body'=>str_replace('$1', htmlspecialchars($page),
				str_replace('$2', 'WikiName', $_msg_invalidiwn))
		);
	}
}
?>
