<?php

// ---------------------------------------------
// redirect.inc.php   v. 0.9
//
// 任意のページにリダイレクトする
// URLを設定しない場合は、トップへ
// 管理モードで以外で表示したくないページに使うと便利
// writed by hokuken.com 2007 8/24
// ----------------------------------------------- 


function plugin_redirect_convert()
{
	global $vars, $script;
	global $enable_cache;

     //キャッシュしない
     $enable_cache = false;
     
    $page = isset($vars['page']) ? $vars['page'] : '';
    
    $args = func_get_args();
    $url = strip_autolink(array_pop($args));
    
    if($url == ''){
    	$url = $script.'?FrontPage';
    }
    else{
       $url = is_url($url) ? $url : $script . '?'.rawurlencode($url);
    }
        
    $editable = ss_admin_check();
    
    
    //自分自身にリダイレクトして、ループする場合は警告する
    if($url===$script.'?'.rawurlencode($page)){
     
        return '<p><strong style="background-color:yellow">【警告】redirectプラグインによる転送先が、このページ自身になっています。別のページを指定して下さい。</strong></p>';
     }
    
    if($editable){
        return "<p><strong>【お知らせ】管理者モード以外のアクセスは、redirectプラグインによって、"
        . "<a href=\"$url\" target=\"_blank\">". $url . "</a> に転送されます。</strong></p>";
    }
    else{        
        header("Location: $url");
        exit();
    }
}


?>
