<?php
// PukiWiki - Yet another WikiWikiWeb clone
// $Id: update_entities.inc.php,v 1.9 2005/06/23 18:00:07 teanan Exp $
//
// Update entities plugin - Update XHTML entities from DTD
// (for admin)

// DTDの場所
define('W3C_XHTML_DTD_LOCATION', 'http://www.w3.org/TR/xhtml1/DTD/');

// メッセージ設定
function plugin_update_tinycode_init()
{
	$messages = array(
		'_entities_messages'=>array(
			'title_update'  => 'ページへの短縮URLデータの更新',
			'msg_adminpass' => '管理者パスワード',
			'btn_submit'    => '実行',
			'msg_done'      => 'データベースを更新しました',
			'msg_usage'     => '
&size(16){&color(red){【お知らせ】};};
　&size(16){&color(red){ページを開いただけでは、作業は行われていません};};
　&size(16){&color(red){ページ末尾で、管理者パスワードを入力し、「実行ボタン」を押して下さい};};

* 処理内容

QHMでは、長いURLになるページでも、「別の短いURL」でアクセス可能にしています。
この別URLのデータベースを更新します。

処理内容は、以下の通りです。

+ データ登録がないページを登録する
+ 存在しないデータを削除する

既存のリンクが変わることはありません。

&br;

* 実行
管理者パスワードを入力して、[実行]ボタンをクリックしてください。
クリック直後に、実行されます。
'
		));
	set_plugin_messages($messages);
}

function plugin_update_tinycode_action()
{
	global $script, $vars, $defaultpage;
	global $_entities_messages;

	if (PKWK_READONLY) die_message('PKWK_READONLY prohibits this');

	$msg = $body = '';
	if (empty($vars['action']) || empty($vars['adminpass']) || ! pkwk_login($vars['adminpass'])) {
		$msg   = & $_entities_messages['title_update'];
		$body  = convert_html($_entities_messages['msg_usage']);
		$body .= <<<EOD
<form method="POST" action="$script">
 <div>
  <input type="hidden" name="plugin" value="update_tinycode" />
  <input type="hidden" name="action" value="update" />
  <label for="_p_update_entities_adminpass">{$_entities_messages['msg_adminpass']}</label>
  <input type="password" name="adminpass" id="_p_update_entities_adminpass" size="20" value="" />
  <input type="submit" value="{$_entities_messages['btn_submit']}" />
 </div>
</form>
EOD;
	} else if ($vars['action'] == 'update') {
		plugin_update_tinycode_do();
		$msg  = & $_entities_messages['title_update'];
		$body = & $_entities_messages['msg_done'    ];
	} else {
		$msg  = & $_entities_messages['title_update'];
		$body = & $_entities_messages['err_invalid' ];
	}
	return array('msg'=>$msg, 'body'=>$body);
}

// Remove &amp; => amp
function plugin_update_tinycode_do(){

	//dbがなければ、自動的に作られる
	add_tinycode($defaultpage);
	
	//file add
	$exists = get_existpages();
	$tcodes = get_tiny_table();
	$list = array_diff($exists, $tcodes);
	
	foreach($list as $v){
		add_tinycode($v);
	}
	
	//file del
	$tcodes = get_tiny_table();
	$list = array_diff($tcodes, $exists);

	foreach($list as $v){
		del_tinycode($v);
	}
}

?>
